ORCA/M Asm65816 2.1.0

0001 2796                       title 'Desk Manager--CDAMenu'
0002 2796              **********************************************************************
0003 2796              *
0004 2796              * Desk Manager--CDAMenu for the Apple II GS
0005 2796              *
0006 2796              * Original CDA code by John Worthinton.
0007 2796              * Original NDA code by Steven Glass
0008 2796              *
0009 2796              * Additions and alterations by Steven Glass and
0010 2796              * Konstantin Othmer
0011 2796              *
0012 2796              * This file contains all the code necessary to handle the CDA menu.
0013 2796              *
0014 2796              * The procedures in this file are:
0015 2796              *
0016 2796              *                   DAHandler
0017 2796              *                   DoCDAMenu
0018 2796              *                   DisplayData
0019 2796              *                   SortCDAs
0020 2796              *                   ChooseCDA
0021 2796              *                   InitStuff
0022 2796              *                   GotReturn
0023 2796              *                   MonKeyIn
0024 2796              *                   EvntKeyIn
0025 2796              *                   Pg2Kludge
0026 2796              *                   UpdateCDAMenu
0027 2796              *                   PrintDAList
0028 2796              *                   WriteDAName
0029 2796              *                   SetUpTab
0030 2796              *                   OpenDA
0031 2796              *                   Deref*
0032 2796              *
0033 2796              **********************************************************************
0034 2796
0035 2796              **********************************************************************
0036 2796              *                                                                    *
0037 2796              *                   Copyright (C) 1985-1991                          *
0038 2796              *                   Apple Computer, Inc.                             *
0039 2796              *                   All Rights Reserved                              *
0040 2796              *                                                                    *
0041 2796              **********************************************************************
0042 2796              *
0043 2796              * 26-Sep-90     Dave Lyons
0044 2796              *
0045 2796              * Change setmode8 to shortmx, setmode16 to longmx.
0046 2796              *
0047 2796              * 27-Nov-90     Dave Lyons
0048 2796              *
0049 2796              * Added SortCDAs routine, and made ChooseCDA call it.
0050 2796              * Optimized a few bytes from cout.
0051 2796              *
0052 2796              * 12-Feb-91     Dave Lyons
0053 2796              *
0054 2796              * Changed the GetNextEvent call to use event mask $0028 instead of
0055 2796              * $FFFF (we don't want to get update events and cause CheckUpdate
0056 2796              * calls, since this interferes with QuickDraw debugging!).
0057 2796              *
0058 2796              * 30-Sep-91     Dave Lyons
0059 2796              *
0060 2796              * Added support in MyWriteline for Ctrl-N to cancel Inverse text,
0061 2796              * since the Text.Clock CDA uses this:  "[Text Clock]: on"
0062 2796              *
0063 2796              **********************************************************************
0064 2796              *
0065 2796              * 7-Jul-92      Dave Lyons
0066 2796              *
0067 2796              * PanelActive checks ROM version using FWEntry before trying to check
0068 2796              * for the ROM 3 Control Panel disable jumper using ReadKeyMicroMemory.
0069 2796              *
0070 2796              **********************************************************************
0071 2796
0072 2796                       msb ON 
0073 2796
0074 2796                       include 'all.macros' 
0075 2796                       include '::sys.equs.asm' 
0076 2796                       include 'e16.memory' 
0077 2796
0078 2796
0079 2796              DAVersionNumber equ $8301               ;8300
0080 2796
0081 2796              Slot_Arbiter equ $E10208 
0082 2796
0083 2796                       include 'Desk.Equates.asm' 
0084 2796
0085 2796
0086 2796                       title 'CDAMenu--DAhandler' 
0087 2796              ****************************************************************
0088 2796              *
0089 2796              DAHandler PROC EXPORT 
0090 2796              *
0091 2796              * This is the code that handles Desk Accessory interrupts.
0092 2796              * When a CDA interrupt occurs, this handler gets control
0093 2796              * in 8-bit native mode.  It decides whether actually put
0094 2796              * up the CDA menu or schedule an event.
0095 2796              *
0096 2796              * Note that this handler does not get called if the EventManger
0097 2796              * is active.  In that case, the Event Manager installs its own
0098 2796              * interrupt handler whose job it is to post events.
0099 2796              *
0100 2796              *
0101 2796              * Inputs:
0102 2796              *                   none
0103 2796              *
0104 2796              * Outputs:
0105 2796              *                   carry clear indicates that interrupt
0106 2796              *                   is handled.
0107 2796              *
0108 2796              * External Refs:
0109 2796                       import DoCDAMenu 
0110 2796              *
0111 2796              * Entry Points:
0112 2796              *                   none
0113 2796              *
0114 2796                       longa off                      ; mode
0115 2796                       longi off
0116 2796              *
0117 2796              * Change History
0118 2796              *
0119 2796              * 19 Jul 88         Steven Glass
0120 2796              *
0121 2796              * This code used to be part of the procedure DABootInit.  It is
0122 2796              * now separate and more self contained.  
0123 2796              *
0124 2796              ****************************************************************
0125 2796
0126 2796 08                    php                            ; save status register
0127 2797
0128 2797              ;-----------------------------------------------------------
0129 2797              ;
0130 2797              ; Check the global variable NumInts.  If this number is
0131 2797              ; is negative, we aren't alread in the CDA menu.  This
0132 2797              ; prevents multiple entries into the CDA menu.
0133 2797              ;
0134 2797 AF 67 1D E0           lda   >numints
0135 279B 1A                    inc   a
0136 279C D0 25                 bne   AllDone
0137 279E
0138 279E
0139 279E              ;-----------------------------------------------------------
0140 279E              ;
0141 279E              ; Check the busy flag.  If it is not zero, we schedule
0142 279E              ; an interrupt.  If it is zero, we go ahead now.
0143 279E              ;
0144 279E AF FF 00 E1           lda   >busyflag                ; if busyflg is 0 then we can
0145 27A2 D0 06                 bne   ScheduleIt
0146 27A4
0147 27A4 22 C6 2C 02           jsl   DoCDAMenu
0148 27A8 80 19                 bra   AllDone
0149 27AA
0150 27AA C2 30        ScheduleIt longmx                       ; switch to full native to make call
0151 27AC 48                    pha                            ; space for result
0152 27AD F4 02 00 F4           PushLong #DoCDAMenu            ; get in the scheduler's que
0153 27B3 A2 07 09 22           _SchAddTask 
0154 27BA 68                    pla                            ; ignore result
0155 27BB
0156 27BB E2 30                 shortmx                        ; switch back to 8-bit native
0157 27BD
0158 27BD A9 FF                 lda   #$FF                     ; reset the NumInts variable
0159 27BF 8F 67 1D E0           sta   >numints
0160 27C3
0161 27C3 28           AllDone  plp                            ; restore P
0162 27C4 18                    clc                            ; claim the interrupt
0163 27C5 6B                    rtl                            ; all done.
0164 27C6
0165 27C6
0166 27C6                       ENDP 
0167 27C6
0168 27C6                       title 'CDAMenu--DoCDAMenu'
0169 27C6              ****************************************************************
0170 27C6              *
0171 27C6              DoCDAMenu PROC 
0172 27C6              *
0173 27C6              * This is the routine that is called to display the CDA
0174 27C6              * menu.  It is either called by the DA interrupt handler
0175 27C6              * (if it is safe to do so) or by the scheduler.
0176 27C6              *
0177 27C6              * This code can be called in either 8, or 16 bit native
0178 27C6              * mode and should work fine.
0179 27C6              *
0180 27C6              * This code resets the variable NumInts to $FF and it sets
0181 27C6              * the next byte after it (mmode) to zero.  Why it does this
0182 27C6              * is not really know, but must accesses to NumInts seem
0183 27C6              * to trash mmode.
0184 27C6              *
0185 27C6              *
0186 27C6              * Inputs:
0187 27C6              *                   none
0188 27C6              *
0189 27C6              * Outputs:
0190 27C6              *                   none
0191 27C6              *
0192 27C6              * External Refs:
0193 27C6              *                   none
0194 27C6              *
0195 27C6              * Entry Points:
0196 27C6              *                   none
0197 27C6              *
0198 27C6                       longa on                       ; mode
0199 27C6                       longi on
0200 27C6              *
0201 27C6              * Change History
0202 27C6              *
0203 27C6              * 19 Jul 88         Steven Glass
0204 27C6              *
0205 27C6              * This code used to be part of the procedure DABootInit.  It is
0206 27C6              * now separate and more self contained.  The same code is called
0207 27C6              * in the same way whether or not the scheduler is used.
0208 27C6              *
0209 27C6              * This code used to save and restore the dbr around the 
0210 27C6              * code that moved the stack.  Instead, we save and restore the dbr at
0211 27C6              * the same time as the processor.
0212 27C6              *
0213 27C6              ****************************************************************
0214 27C6
0215 27C6 08                    php                            ; save m&x bits
0216 27C7 8B                    phb                            ; save dbr
0217 27C8 C2 30                 longmx                         ; now in full native mode.
0218 27CA
0219 27CA 3B                    tsc                            ; save stack for integer basic
0220 27CB 8F 9C 1D E0           sta   >stacksv
0221 27CF
0222 27CF              ; Save stack but don't worry about changing data bank.
0223 27CF              ; it is saved above and restored below with P.
0224 27CF              ;
0225 27CF A2 00 01              ldx   #$0100                   ; stack is saved as $E0/0300
0226 27D2 A0 00 03              ldy   #$0300
0227 27D5 A9 FF 00              lda   #$FF
0228 27D8 54 E0 00              mvn   $000000,$E00000
0229 27DB
0230 27DB A9 FB 01              lda   #$1FB                    ; make sure there's room on stack
0231 27DE 1B                    tcs   
0232 27DF
0233 27DF A2 05 0B 22           _SaveAll                       ; save everything
0234 27E6 A2 05 11 22           _ChooseCDA                     ; display the list of da's
0235 27ED A2 05 0C 22           _RestAll                       ; unsave everything
0236 27F4
0237 27F4
0238 27F4 A9 FF 00              lda   #$FF                     ; clear numints on exit
0239 27F7 8F 67 1D E0           sta   >numints                 ; trash next byte too!!!!!!!!!!!!!!
0240 27FB
0241 27FB A2 00 03              ldx   #$0300                   ; move stack from buffer back to 
0242 27FE A0 00 01              ldy   #$0100                   ; page 1.
0243 2801 A9 FF 00              lda   #$FF
0244 2804 54 00 E0              mvn   $E00000,$000000
0245 2807
0246 2807 AF 9C 1D E0           lda   >stacksv                 ; restore stack pointer.
0247 280B 1B                    tcs   
0248 280C
0249 280C AB                    plb                            ; restore dbr
0250 280D 28                    plp                            ; restore m & x bits.
0251 280E 6B                    rtl   
0252 280F
0253 280F
0254 280F                       ENDP 
0255 280F
0256 280F
0257 280F
0258 280F                       title 'CDAMenu--DisplayData'
0259 280F              displaydata PROC EXPORT 
0260 280F
0261 280F
0262 280F                       EXPORT topofmenu
0263 280F A0           topofmenu DC B:$A0
0264 2810 DF                    DC B:$DF
0265 2811 DF                    DC B:$DF
0266 2812 DF                    DC B:$DF
0267 2813 DF                    DC B:$DF
0268 2814 DF                    DC B:$DF
0269 2815 DF                    DC B:$DF
0270 2816 DF                    DC B:$DF
0271 2817 DF                    DC B:$DF
0272 2818 DF                    DC B:$DF
0273 2819 DF                    DC B:$DF
0274 281A DF                    DC B:$DF
0275 281B DF                    DC B:$DF
0276 281C DF                    DC B:$DF
0277 281D DF                    DC B:$DF
0278 281E DF                    DC B:$DF
0279 281F DF                    DC B:$DF
0280 2820 DF                    DC B:$DF
0281 2821 DF                    DC B:$DF
0282 2822 DF                    DC B:$DF
0283 2823 DF                    DC B:$DF
0284 2824 DF                    DC B:$DF
0285 2825 DF                    DC B:$DF
0286 2826 DF                    DC B:$DF
0287 2827 DF                    DC B:$DF
0288 2828 DF                    DC B:$DF
0289 2829 DF                    DC B:$DF
0290 282A DF                    DC B:$DF
0291 282B DF                    DC B:$DF
0292 282C DF                    DC B:$DF
0293 282D DF                    DC B:$DF
0294 282E DF                    DC B:$DF
0295 282F DF                    DC B:$DF
0296 2830 DF                    DC B:$DF
0297 2831 DF                    DC B:$DF
0298 2832 DF                    DC B:$DF
0299 2833 DF                    DC B:$DF
0300 2834 DF                    DC B:$DF
0301 2835 DF                    DC B:$DF
0302 2836 A0 00                 DC B:$A0,$00
0303 2838
0304 2838                       EXPORT mainstr
0305 2838 5A A0 41 A0  mainstr  DC B:$5A,$A0,$41,$A0
0306 283C C4 E5 F3 EB           DC B:'Desk Accessories '
0307 284D 20                    DC B:$20
0308 284E 20                    DC B:$20
0309 284F 20                    DC B:$20
0310 2850 20                    DC B:$20
0311 2851 20                    DC B:$20
0312 2852 20                    DC B:$20
0313 2853 20                    DC B:$20
0314 2854 20                    DC B:$20
0315 2855 20                    DC B:$20
0316 2856 20                    DC B:$20
0317 2857 20                    DC B:$20
0318 2858 20                    DC B:$20
0319 2859 20                    DC B:$20
0320 285A 20                    DC B:$20
0321 285B 20                    DC B:$20
0322 285C 20                    DC B:$20
0323 285D 20                    DC B:$20
0324 285E 20                    DC B:$20
0325 285F 5F 00                 DC B:$5F,$00
0326 2861
0327 2861                       EXPORT bottmofmenu
0328 2861 5A           bottmofmenu DC B:$5A
0329 2862 4C                    DC B:$4C
0330 2863 4C                    DC B:$4C
0331 2864 4C                    DC B:$4C
0332 2865 4C                    DC B:$4C
0333 2866 4C                    DC B:$4C
0334 2867 4C                    DC B:$4C
0335 2868 4C                    DC B:$4C
0336 2869 4C                    DC B:$4C
0337 286A 4C                    DC B:$4C
0338 286B 4C                    DC B:$4C
0339 286C 4C                    DC B:$4C
0340 286D 4C                    DC B:$4C
0341 286E 4C                    DC B:$4C
0342 286F 4C                    DC B:$4C
0343 2870 4C                    DC B:$4C
0344 2871 4C                    DC B:$4C
0345 2872 4C                    DC B:$4C
0346 2873 4C                    DC B:$4C
0347 2874 4C                    DC B:$4C
0348 2875 4C                    DC B:$4C
0349 2876 4C                    DC B:$4C
0350 2877 4C                    DC B:$4C
0351 2878 4C                    DC B:$4C
0352 2879 4C                    DC B:$4C
0353 287A 4C                    DC B:$4C
0354 287B 4C                    DC B:$4C
0355 287C 4C                    DC B:$4C
0356 287D 4C                    DC B:$4C
0357 287E 4C                    DC B:$4C
0358 287F 4C                    DC B:$4C
0359 2880 4C                    DC B:$4C
0360 2881 4C                    DC B:$4C
0361 2882 4C                    DC B:$4C
0362 2883 4C                    DC B:$4C
0363 2884 4C                    DC B:$4C
0364 2885 4C                    DC B:$4C
0365 2886 4C                    DC B:$4C
0366 2887 4C                    DC B:$4C
0367 2888 5F 00                 DC B:$5F,$00
0368 288A
0369 288A              ;	EXPORT	midstr
0370 288A              ;midstr	DC.B	$5A
0371 288A              ;	DC.B	$FF,$24,$A0
0372 288A              ;	DC.B	$5F,$00
0373 288A
0374 288A                       EXPORT selectstr
0375 288A 5A           selectstr DC B:$5A
0376 288B A0 D3 E5 EC           DC B:' Select: '
0377 2894 4A A0 4B              DC B:$4A,$A0,$4B
0378 2897 A0                    DC B:$A0
0379 2898 A0                    DC B:$A0
0380 2899 A0                    DC B:$A0
0381 289A A0                    DC B:$A0
0382 289B A0                    DC B:$A0
0383 289C A0                    DC B:$A0
0384 289D A0                    DC B:$A0
0385 289E A0                    DC B:$A0
0386 289F A0                    DC B:$A0
0387 28A0 A0                    DC B:$A0
0388 28A1 A0                    DC B:$A0
0389 28A2 A0                    DC B:$A0
0390 28A3 A0                    DC B:$A0
0391 28A4 A0                    DC B:$A0
0392 28A5 A0                    DC B:$A0
0393 28A6 A0                    DC B:$A0
0394 28A7 A0                    DC B:$A0
0395 28A8 CF F0 E5 EE           DC B:'Open: '
0396 28AE 4D A0 A0 5F           DC B:$4D,$A0,$A0,$5F,$00
0397 28B3
0398 28B3                       EXPORT laststr
0399 28B3 A0           laststr  DC B:$A0
0400 28B4 4C                    DC B:$4C
0401 28B5 4C                    DC B:$4C
0402 28B6 4C                    DC B:$4C
0403 28B7 4C                    DC B:$4C
0404 28B8 4C                    DC B:$4C
0405 28B9 4C                    DC B:$4C
0406 28BA 4C                    DC B:$4C
0407 28BB 4C                    DC B:$4C
0408 28BC 4C                    DC B:$4C
0409 28BD 4C                    DC B:$4C
0410 28BE 4C                    DC B:$4C
0411 28BF 4C                    DC B:$4C
0412 28C0 4C                    DC B:$4C
0413 28C1 4C                    DC B:$4C
0414 28C2 4C                    DC B:$4C
0415 28C3 4C                    DC B:$4C
0416 28C4 4C                    DC B:$4C
0417 28C5 4C                    DC B:$4C
0418 28C6 4C                    DC B:$4C
0419 28C7 4C                    DC B:$4C
0420 28C8 4C                    DC B:$4C
0421 28C9 4C                    DC B:$4C
0422 28CA 4C                    DC B:$4C
0423 28CB 4C                    DC B:$4C
0424 28CC 4C                    DC B:$4C
0425 28CD 4C                    DC B:$4C
0426 28CE 4C                    DC B:$4C
0427 28CF 4C                    DC B:$4C
0428 28D0 4C                    DC B:$4C
0429 28D1 4C                    DC B:$4C
0430 28D2 4C                    DC B:$4C
0431 28D3 4C                    DC B:$4C
0432 28D4 4C                    DC B:$4C
0433 28D5 4C                    DC B:$4C
0434 28D6 4C                    DC B:$4C
0435 28D7 4C                    DC B:$4C
0436 28D8 4C                    DC B:$4C
0437 28D9 4C                    DC B:$4C
0438 28DA 00                    DC B:$00
0439 28DB
0440 28DB                       EXPORT uparrows
0441 28DB              uparrows  
0442 28DB              *** Commented out the text because it's exactly the same as downarrows.  12-Feb-91 DAL
0443 28DB              ***	DC.B	$5B,$5B,$5B,$A0,'more',$A0,$5B,$5B,$5B	;up arrows are 4B
0444 28DB              ***	DC.B	$00
0445 28DB                       EXPORT downarrows
0446 28DB 5B 5B 5B A0  downarrows DC B:$5B,$5B,$5B,$A0,'more',$A0,$5B,$5B,$5B ;down arrows are 4A
0447 28E7 00                    DC B:$00
0448 28E8
0449 28E8                       EXPORT blankline
0450 28E8 A0 A0 A0 A0  blankline DC B:'                                    '
0451 290C 00                    DC B:$00
0452 290D
0453 290D
0454 290D                       EXPORT dastr
0455 290D 38 2D 02 00  dastr    DC L:mainstr
0456 2911 1D 2E 02 00           DC L:cntrlstr
0457 2915 2B 2E 02 00           DC L:quitstr
0458 2919 8A 2D 02 00           DC L:selectstr
0459 291D
0460 291D                       EXPORT cntrlstr
0461 291D C3 EF EE F4  cntrlstr DC B:'Control Panel'
0462 292A 00                    DC B:$00
0463 292B
0464 292B                       EXPORT quitstr
0465 292B D1 F5 E9 F4  quitstr  DC B:'Quit'
0466 292F 00                    DC B:$00
0467 2930
0468 2930
0469 2930                       ENDP 
0470 2930
0471 2930
0472 2930              ****************************************************************
0473 2930              *
0474 2930              * SortCDAs  27-Nov-90 DAL
0475 2930              *
0476 2930              * If bit 0 of battery-RAM location $5F is on, we sort the CDA
0477 2930              * handles into alphabetical order before displaying the menu.
0478 2930              *
0479 2930              * ChooseCDA calls SortCDAs (from RAM on ROM 1, and through a
0480 2930              * patch to ROM 3).
0481 2930              *
0482 2930              ****************************************************************
0483 2930              SortCDAs proc export 
0484 2930
0485 2930 48                    pha                            ;space for result
0486 2931 F4 5F 00              pea   $5F
0487 2934 A2 03 0C 22           _ReadBParam 
0488 293B 68                    pla   
0489 293C 4A                    lsr   a
0490 293D 90 34                 bcc   cdaDontSort
0491 293F
0492 293F              swapFlag equ   1
0493 293F              counter  equ   swapFlag+2
0494 293F              str1     equ   counter+2
0495 293F              str2     equ   str1+4
0496 293F              myPtr    equ   str2+4
0497 293F
0498 293F AF 7C 1D E0           lda   >NumDAs
0499 2943 F0 2E                 beq   @SortDone                ;if there aren't any, we're done
0500 2945 3A                    dec   a
0501 2946 F0 2B                 beq   @SortDone                ;if there's only one, we're done
0502 2948
0503 2948 0B                    phd   
0504 2949 AF 86 1D E0           lda   >CDATabHndl+2
0505 294D 48                    pha   
0506 294E AF 84 1D E0           lda   >CDATabHndl
0507 2952 48                    pha   
0508 2953 DA                    phx   
0509 2954 DA                    phx                            ;space for str2
0510 2955 DA                    phx   
0511 2956 DA                    phx                            ;space for str1
0512 2957 DA                    phx                            ;space for counter
0513 2958 DA                    phx                            ;space for swapFlag
0514 2959 3B                    tsc   
0515 295A 5B                    tcd   
0516 295B              ** deref myPtr=CDATabHndl into pointer
0517 295B A0 02 00              ldy   #2
0518 295E B7 0D                 lda   [<myPtr],y
0519 2960 AA                    tax   
0520 2961 A7 0D                 lda   [<myPtr]
0521 2963 85 0D                 sta   <myPtr
0522 2965 86 0F                 stx   <myPtr+2
0523 2967
0524 2967 20 74 2E              jsr   cdaDoTheSort
0525 296A
0526 296A FA                    plx   
0527 296B FA                    plx   
0528 296C FA                    plx   
0529 296D FA                    plx   
0530 296E FA                    plx   
0531 296F FA                    plx   
0532 2970 FA                    plx   
0533 2971 FA                    plx   
0534 2972 2B                    pld   
0535 2973              @SortDone  
0536 2973
0537 2973 60           cdaDontSort rts   
0538 2974
0539 2974              *
0540 2974              * cdaDoTheSort
0541 2974              *
0542 2974              * Input: myPtr = pointer to the list of CDA handles
0543 2974              *        >NumDAs = number of CDAs (AT LEAST 2!)
0544 2974              *
0545 2974              * Output: the handles in myPtr are sorted so that the
0546 2974              *         CDAs are in alphabetical order
0547 2974              *
0548 2974              * Uses:  swapFlag, counter, str1, str2 (on dp/stack)
0549 2974              *
0550 2974              * The sort ignores bit 7 and ignores case.
0551 2974              *
0552 2974 46 01        cdaDoTheSort lsr   <swapFlag
0553 2976 A0 00 00              ldy   #0                       ;index into myPtr (list of handles)
0554 2979 AF 7C 1D E0           lda   >NumDAs
0555 297D 3A                    dec   a
0556 297E 85 03                 sta   <counter
0557 2980
0558 2980 5A           @checkPair phy   
0559 2981 20 AD 2E              jsr   GetCDANamePtr
0560 2984 86 07                 stx   <str1+2
0561 2986 85 05                 sta   <str1
0562 2988 C8                    iny   
0563 2989 C8                    iny   
0564 298A C8                    iny   
0565 298B C8                    iny   
0566 298C 20 AD 2E              jsr   GetCDANamePtr
0567 298F 86 0B                 stx   <str2+2
0568 2991 85 09                 sta   <str2
0569 2993
0570 2993 20 C7 2E              jsr   CompareDANames
0571 2996 90 07                 bcc   @noSwap
0572 2998 66 01                 ror   <swapFlag                ;set bit 15 = we had to swap something
0573 299A
0574 299A 7A                    ply   
0575 299B 5A                    phy   
0576 299C 20 02 2F              jsr   SwapYandNext
0577 299F
0578 299F 7A           @noSwap  ply   
0579 29A0 C8                    iny   
0580 29A1 C8                    iny   
0581 29A2 C8                    iny   
0582 29A3 C8                    iny   
0583 29A4 C6 03                 dec   <counter
0584 29A6 D0 D8                 bne   @checkPair
0585 29A8
0586 29A8 24 01                 bit   <swapFlag
0587 29AA 30 C8                 bmi   cdaDoTheSort
0588 29AC 60                    rts   
0589 29AD              *
0590 29AD              * GetCDANamePtr
0591 29AD              *
0592 29AD              * Input: Y = index into handle list (preserved)
0593 29AD              *        <myPtr = pointer to list of handles
0594 29AD              *
0595 29AD              * Output: XA = pointer to CDA (name)
0596 29AD              *
0597 29AD 5A           GetCDANamePtr phy   
0598 29AE B7 0D                 lda   [<myPtr],y
0599 29B0 AA                    tax   
0600 29B1 C8                    iny   
0601 29B2 C8                    iny   
0602 29B3 B7 0D                 lda   [<myPtr],y               ;got XA = handle to a CDA
0603 29B5 0B                    phd   
0604 29B6 48                    pha   
0605 29B7 DA                    phx                            ;push handle on stack for dereference
0606 29B8 3B                    tsc   
0607 29B9 5B                    tcd   
0608 29BA A0 02 00              ldy   #2
0609 29BD B7 01                 lda   [1],y
0610 29BF AA                    tax                            ;return high word of pointer
0611 29C0 A7 01                 lda   [1]                      ;return low word of pointer
0612 29C2 7A                    ply                            ;throw away handle
0613 29C3 7A                    ply                            ;throw away handle
0614 29C4 2B                    pld                            ;restore D
0615 29C5 7A                    ply                            ;restore caller's Y
0616 29C6 60                    rts   
0617 29C7
0618 29C7              *
0619 29C7              * CompareCDANames
0620 29C7              *
0621 29C7              * Input: str1, str2
0622 29C7              *
0623 29C7              * Output: CLC if DAs are correctly ordered
0624 29C7              *
0625 29C7 A0 00 00     CompareDANames ldy   #0
0626 29CA 98           @pchar   tya   
0627 29CB E2 20                 sep   #$20
0628 29CD C7 05                 cmp   [<str1]
0629 29CF C2 20                 rep   #$20
0630 29D1 B0 2D                 bcs   @clc                     ;return with carry clear (hit end of first string)
0631 29D3
0632 29D3 E2 20                 sep   #$20
0633 29D5 C7 09                 cmp   [<str2]
0634 29D7 C2 20                 rep   #$20
0635 29D9 B0 14                 bcs   @rts                     ;return with carry set (hit end of 2nd string)
0636 29DB
0637 29DB C8                    iny   
0638 29DC B7 09                 lda   [<str2],y
0639 29DE 20 F0 2E              jsr   @upcase
0640 29E1 8F EB 2E 02           sta   >@cheat+1
0641 29E5 B7 05                 lda   [<str1],y
0642 29E7 20 F0 2E              jsr   @upcase
0643 29EA C9 77 77     @cheat   cmp   #$7777                   ;self-modified
0644 29ED F0 DB                 beq   @pchar
0645 29EF 60           @rts     rts                            ;returns carry
0646 29F0
0647 29F0 29 7F 00     @upcase  and   #$007f
0648 29F3 C9 E1 00              cmp   #'a'
0649 29F6 90 09                 bcc   @1
0650 29F8 C9 FB 00              cmp   #'z'+1
0651 29FB B0 04                 bcs   @1
0652 29FD 29 DF 00              and   #$df
0653 2A00 18           @clc     clc   
0654 2A01 60           @1       rts   
0655 2A02
0656 2A02              *
0657 2A02              * SwapYandNext
0658 2A02              *
0659 2A02              * Input: Y = index to a handle in the <myPtr list
0660 2A02              *
0661 2A02              * Swaps the handle with the one following
0662 2A02              *
0663 2A02              * Trashes A, X, Y.
0664 2A02              *
0665 2A02 A2 04 00     SwapYandNext ldx   #4
0666 2A05 5A                    phy   
0667 2A06 B7 0D        @push    lda   [<myPtr],y
0668 2A08 48                    pha   
0669 2A09 C8                    iny   
0670 2A0A C8                    iny   
0671 2A0B CA                    dex   
0672 2A0C D0 F8                 bne   @push
0673 2A0E A3 09                 lda   9,s                      ;get old index back
0674 2A10 A8                    tay   
0675 2A11 FA                    plx   
0676 2A12 68                    pla                            ;XA=2nd handle
0677 2A13 97 0D                 sta   [<myPtr],y
0678 2A15 C8                    iny   
0679 2A16 C8                    iny   
0680 2A17 8A                    txa   
0681 2A18 97 0D                 sta   [<myPtr],y
0682 2A1A
0683 2A1A FA                    plx   
0684 2A1B 68                    pla                            ;XA=old first handle
0685 2A1C C8                    iny   
0686 2A1D C8                    iny   
0687 2A1E 97 0D                 sta   [<myPtr],y
0688 2A20 C8                    iny   
0689 2A21 C8                    iny   
0690 2A22 8A                    txa   
0691 2A23 97 0D                 sta   [<myPtr],y
0692 2A25
0693 2A25 7A                    ply   
0694 2A26 60                    rts   
0695 2A27
0696 2A27                       EndP 
0697 2A27
0698 2A27
0699 2A27              ****************************************************************
0700 2A27              *
0701 2A27              ChooseCDA PROC EXPORT 
0702 2A27              *
0703 2A27              * ChooseCDA is the internal routine that causes the CDA menu
0704 2A27              * to be displayed.
0705 2A27              *
0706 2A27              * The system must already be in text mode before this call is
0707 2A27              * made.  This call assumes that stack and d-page are already
0708 2A27              * set to page 1 and page 0.
0709 2A27              *
0710 2A27              *
0711 2A27              * Inputs:
0712 2A27              *                   none
0713 2A27              *
0714 2A27              * Outputs:
0715 2A27              *                   none
0716 2A27              *
0717 2A27              * External Refs:
0718 2A27              *                   none
0719 2A27              *
0720 2A27              * Entry Points:
0721 2A27              *                   none
0722 2A27              *
0723 2A27                       longa on                       ; mode
0724 2A27                       longi on
0725 2A27              *
0726 2A27              *
0727 2A27              * Change History:
0728 2A27              *
0729 2A27              *  Halloween        Kontstantin Othmer
0730 2A27              *
0731 2A27              *   Added warm entry point so that current state of desk manager
0732 2A27              * is saved and returned to after the cda call is done.
0733 2A27              * Also took out all the brks.
0734 2A27              *
0735 2A27              ****************************************************************
0736 2A27
0737 2A27 20 30 2E              jsr   SortCDAs                 ;added 27-Nov-90 DAL
0738 2A2A
0739 2A2A 8B                    phb                            ; save dbr
0740 2A2B
0741 2A2B A9 00 00              lda   #0
0742 2A2E 8F 80 1D E0           sta   >firstMenuItem           ; tell UpdateCDA to start at item 0
0743 2A32 8F B0 1D E0           sta   >curCDA                  ; select item 0 (control panel)
0744 2A36
0745 2A36 A9 03 00              lda   #$0003                   ;request current bit encoded configuration
0746 2A39 22 08 02 E1           jsl   Slot_Arbiter             ;and make slot 3 internal
0747 2A3D DA                    phx                            ;saves bit encoded configuration
0748 2A3E
0749 2A3E
0750 2A3E                       ENTRY ChooseCDAWarm 
0751 2A3E              ChooseCDAWarm  
0752 2A3E
0753 2A3E F4 E0 E0              pea   $E0E0                    ;Reset dbr to bank $E0
0754 2A41 AB                    plb   
0755 2A42 AB                    plb   
0756 2A43              SkipWarm  
0757 2A43 20 AE 32              jsr   initstuff                ;This inits all formatting parameters
0758 2A46
0759 2A46 F4 FF 00              pea   $FF                      ; and mask
0760 2A49 F4 00 00              pea   $00                      ; or mask
0761 2A4C A2 0C 0A 22           _SetOutGlobals 
0762 2A53
0763 2A53 F4 00 00              pea   00                       ; device type
0764 2A56 F4 00 00 F4           pushlong #$03                  ; pointer to driver
0765 2A5C A2 0C 10 22           _SetOutputDevice 
0766 2A63
0767 2A63              *
0768 2A63              * Determine whether or not we have an 80 column card
0769 2A63              *  Later we will use this information for setting the position of the menu
0770 2A63              *  In 40 column mode, the menu starts in column 0
0771 2A63              *  In 80 column mode, the menu starts in column 20
0772 2A63              *
0773 2A63 E2 30        loop13   shortmx 
0774 2A65 A2 00                 ldx   #$00                     ; check for 80-col card in place
0775 2A67 AD 05 C3     loop4card lda   $C305
0776 2A6A C9 38                 cmp   #$38
0777 2A6C D0 0C                 bne   nocard
0778 2A6E AD 07 C3              lda   $C307
0779 2A71 C9 18                 cmp   #$18
0780 2A73 D0 05                 bne   nocard
0781 2A75 E8                    inx   
0782 2A76 D0 EF                 bne   loop4card
0783 2A78 80 05                 bra   cz2
0784 2A7A
0785 2A7A 8D 0A C0     nocard   sta   |setintc3rom             ; just to make sure its really in
0786 2A7D 80 E8                 bra   loop4card
0787 2A7F
0788 2A7F A9 FF        cz2      lda   #$FF
0789 2A81 8F 32 00 00           sta   >$000032                 ; turn off inverse
0790 2A85 C2 30                 longmx 
0791 2A87 F4 01 00              pea   01                       ; init device to output
0792 2A8A A2 0C 15 22           _InitTextDev 
0793 2A91
0794 2A91 F4 00 00     cz3      PushWord #00 
0795 2A94 F4 19 00              PushWord #$19                  ; want 40 cols
0796 2A97 A2 03 0C 22           _ReadBParam 
0797 2A9E 68                    pla   
0798 2A9F 29 FF 00              and   #$00FF
0799 2AA2 8D 66 1D              sta   |sv4080
0800 2AA5 D0 1E                 bne   c1                       ;not 40 column; everything is ok
0801 2AA7
0802 2AA7              ; From here to c1 is 40 column init.
0803 2AA7              ; Initstuff assumes 80 columns.
0804 2AA7              ; The only difference is the position of the left border
0805 2AA7
0806 2AA7 A9 11 00              lda   #$11                     ;Special 40 column init stuff
0807 2AAA 20 A5 34              jsr   cout
0808 2AAD
0809 2AAD E2 20                 sep   #$20
0810 2AAF 8F 00 C0 00           sta   >$00C000
0811 2AB3 8F 0C C0 00           sta   >$00C00C
0812 2AB7 C2 20                 rep   #$20
0813 2AB9 A9 03 00              lda   #LeftBorder40            ;Only difference between 80 & 40 is left
0814 2ABC 8D 7E 1D              sta   |leftborder              ;column starting location
0815 2ABF A9 00 00              lda   #LeftBorder40-3
0816 2AC2 8D 72 1D              sta   |hpos                    ;menu border starts two to the left of text
0817 2AC5
0818 2AC5              c1         
0819 2AC5 A9 2D 02              lda   #>topofmenu
0820 2AC8 85 41                 sta   temp2+1
0821 2ACA A9 0F 2D              lda   #<topofmenu
0822 2ACD 85 40                 sta   temp2
0823 2ACF 20 6B 35              jsr   mywritecstringnt
0824 2AD2 EE 74 1D              inc   |vpos
0825 2AD5 AD AC 1D              lda   |dastrptr                ; mainstr for international
0826 2AD8 85 3C                 sta   temp1
0827 2ADA AD AE 1D              lda   |dastrptr+2
0828 2ADD 85 3E                 sta   temp1+2
0829 2ADF A0 02 00              ldy   #$02
0830 2AE2 B7 3C                 lda   [temp1],y
0831 2AE4 85 42                 sta   temp2+2
0832 2AE6 A7 3C                 lda   [temp1]
0833 2AE8 85 40                 sta   temp2
0834 2AEA 20 6B 35              jsr   MyWriteCStringnt         ;Draws the Desk Accessories line
0835 2AED EE 74 1D              inc   |vpos
0836 2AF0 A9 2D 02              lda   #>bottmofmenu
0837 2AF3 85 41                 sta   temp2+1
0838 2AF5 A9 61 2D              lda   #<bottmofmenu
0839 2AF8 85 40                 sta   temp2
0840 2AFA 20 6B 35              jsr   MyWriteCStringnt         ;Draws the bar under Desk Access.
0841 2AFD              ;
0842 2AFD              ; Now print right and left borders of menu
0843 2AFD              ;
0844 2AFD F4 14 00              pushword #$14                  ;$14 = 20 lines of bars in all
0845 2B00 AD 72 1D              lda   |hpos
0846 2B03 48                    pha                            ;save to use in following routine
0847 2B04
0848 2B04              loop      
0849 2B04 A3 01                 lda   1,s
0850 2B06 8D 72 1D              sta   |hpos
0851 2B09 EE 74 1D              inc   |vpos
0852 2B0C 68                    pla   
0853 2B0D FA                    plx   
0854 2B0E CA                    dex   
0855 2B0F F0 19                 beq   cont                     ;Leave loop if borders are done
0856 2B11 DA                    phx   
0857 2B12 48                    pha   
0858 2B13
0859 2B13 A9 5A 00              lda   #$5A                     ;Left Border Bar Character
0860 2B16 20 BB 34              jsr   MyCout
0861 2B19
0862 2B19 A3 01                 lda   1,s                      ;replaces pla pha
0863 2B1B 18                    clc   
0864 2B1C 69 27 00              adc   #WindowWidth             ;Right Border = LeftBorder + Width
0865 2B1F 8D 72 1D              sta   |hpos
0866 2B22
0867 2B22 A9 5F 00              lda   #$5F                     ;Right Border Bar Char
0868 2B25 20 BB 34              jsr   MyCout
0869 2B28
0870 2B28 80 DA                 bra   loop
0871 2B2A
0872 2B2A AD AC 1D     cont     lda   |dastrptr                ; mainstr for international
0873 2B2D 85 3C                 sta   temp1
0874 2B2F AD AE 1D              lda   |dastrptr+2
0875 2B32 85 3E                 sta   temp1+2
0876 2B34 A0 0E 00              ldy   #$0E
0877 2B37 B7 3C                 lda   [temp1],y
0878 2B39 85 42                 sta   temp2+2
0879 2B3B 88                    dey   
0880 2B3C 88                    dey   
0881 2B3D B7 3C                 lda   [temp1],y
0882 2B3F 85 40                 sta   temp2
0883 2B41 20 6B 35              jsr   MyWriteCstringnt         ;draw bottom  "Select:....
0884 2B44 EE 74 1D              inc   |vpos
0885 2B47
0886 2B47 A9 2D 02              lda   #>laststr
0887 2B4A 85 41                 sta   temp2+1
0888 2B4C A9 B3 2D              lda   #<laststr
0889 2B4F 85 40                 sta   temp2
0890 2B51 20 6B 35              jsr   MyWriteCStringnt         ;Draws the bar under Desk Access.
0891 2B54
0892 2B54              ;
0893 2B54              ; if control panel active goto panelactive
0894 2B54              ;
0895 2B54 20 48 36              jsr   panelactive
0896 2B57 AD 7C 1D              lda   |numdas                  ;calculate last vertical position which
0897 2B5A 90 01                 bcc   active
0898 2B5C 3A                    dec   a
0899 2B5D              active    
0900 2B5D
0901 2B5D 18                    clc                            ;contains text
0902 2B5E 69 05 00              adc   #$05                     ;This is used to know where quit will be
0903 2B61 C9 11 00              cmp   #Top+NumLines-1          ;last line a DA can show on
0904 2B64 90 03                 blt   ok
0905 2B66 A9 11 00              lda   #Top+NumLines-1
0906 2B69 8D 70 1D     ok       sta   |bottomline              ;save last text position
0907 2B6C
0908 2B6C 20 39 33              jsr   UpdateCDAMenu            ;draw all available CDAs
0909 2B6F              ;
0910 2B6F              ; Calculate position to draw selected (inverted) item
0911 2B6F              ; Postion is top+(curcda-firstmenuitem)
0912 2B6F              ;
0913 2B6F
0914 2B6F AD B0 1D              lda   |curcda
0915 2B72 38                    sec   
0916 2B73 ED 80 1D              sbc   |firstmenuitem
0917 2B76 18                    clc   
0918 2B77 69 04 00              adc   #top
0919 2B7A 8D 74 1D              sta   |vpos                    ;invert string routine which inverts
0920 2B7D AD 7E 1D              lda   |leftborder              ;the DA with some given number
0921 2B80 8D 72 1D              sta   |hpos
0922 2B83
0923 2B83 A9 FF 00              lda   #$FF                     ; inverse
0924 2B86 AC B0 1D              ldy   |curcda                  ;Item to highlight
0925 2B89 20 84 35              jsr   writedaname              ;Always start by selecting first item
0926 2B8C
0927 2B8C
0928 2B8C 62 05 00     loop1    per   ret-1
0929 2B8F AD 8A 1D              lda   |keyinput                ;simulate a jsr through |keyinput
0930 2B92 3A                    dec   a                        ;(which isn't in the program bank!)
0931 2B93 48                    pha   
0932 2B94 60                    rts   
0933 2B95              ;
0934 2B95              ; Read keyboard and dispatch to appropriate routine
0935 2B95              ;
0936 2B95                       longa on
0937 2B95                       longi on
0938 2B95 29 7F 00     ret      and   #$7F
0939 2B98 C9 0D 00              cmp   #$0D                     ;Open CDA?
0940 2B9B D0 03                 bne   contt
0941 2B9D 4C DE 32              jmp   gotreturn                ;Open it
0942 2BA0 C9 0B 00     contt    cmp   #$0B                     ;up arrow?
0943 2BA3 D0 03                 bne   contt1
0944 2BA5 82 55 01              brl   upaline
0945 2BA8              contt1    
0946 2BA8 C9 0A 00              cmp   #$0A                     ;down arrow?
0947 2BAB F0 36                 beq   downaline
0948 2BAD C9 1B 00              cmp   #$1B                     ;escape key
0949 2BB0              ***	bne	loop1
0950 2BB0 D0 03                 bne   @notESC
0951 2BB2 82 A8 01              brl   DoEscape
0952 2BB5
0953 2BB5              *
0954 2BB5              * Added 12-Feb-91 DAL.  If they didn't type something special, try
0955 2BB5              * to jump to the next CDA that starts with the character they
0956 2BB5              * typed.
0957 2BB5              *
0958 2BB5 C2 30        @notESC  longmx 
0959 2BB7 C9 20 00              cmp   #$20
0960 2BBA 90 D0                 bcc   loop1
0961 2BBC 48                    pha   
0962 2BBD A9 00 00              lda   #0
0963 2BC0 AC B0 1D              ldy   |curcda
0964 2BC3 20 84 35              jsr   WriteDAName
0965 2BC6 68                    pla   
0966 2BC7 20 FA 36              jsr   SearchCDALetter
0967 2BCA              *
0968 2BCA 20 56 37              jsr   GetCDANum                ;Quit = NumDAs+1
0969 2BCD 38                    sec   
0970 2BCE ED 80 1D              sbc   |FirstMenuItem
0971 2BD1 18                    clc   
0972 2BD2 69 04 00              adc   #Top
0973 2BD5 8D 74 1D              sta   |vpos
0974 2BD8              *
0975 2BD8 AC B0 1D              ldy   |curcda
0976 2BDB A9 FF 00              lda   #$ff
0977 2BDE 20 84 35              jsr   WriteDAName
0978 2BE1 80 A9                 bra   loop1
0979 2BE3
0980 2BE3              * Support routines for possible inputs follow
0981 2BE3
0982 2BE3 C2 30        downaline longmx 
0983 2BE5 AC B0 1D              ldy   |curcda                  ; unhighlight current da
0984 2BE8 A9 00 00              lda   #$00
0985 2BEB 20 84 35              jsr   writedaname
0986 2BEE AD B0 1D              lda   |curcda                  ; if curcda = quit then do nothing
0987 2BF1 C9 FF 00              cmp   #$FF
0988 2BF4 D0 0B                 bne   cont1
0989 2BF6              *If quit is selected, do nothing.
0990 2BF6 AD 7E 1D              lda   |leftborder
0991 2BF9 8D 72 1D              sta   |hpos
0992 2BFC A9 FF 00              lda   #$FF
0993 2BFF 80 26                 bra   drawnam
0994 2C01
0995 2C01              cont1     
0996 2C01              * first check to see if the apple key was also pressed.  If it was, we move by pages.
0997 2C01 AD 25 C0              lda   |ModKeyReg               ;Modifier key register $c025
0998 2C04 29 80 00              and   #$0080                   ;apple key bit (page 124 harware ref)
0999 2C07 D0 2B                 bne   DoPageDown
1000 2C09              * here we move down 1 line
1001 2C09              * first check if we need to scroll
1002 2C09 AD 74 1D              lda   |vpos
1003 2C0C C9 11 00              cmp   #Top+NumLines-1          ;are we at the bottom?
1004 2C0F D0 03                 bne   contt2
1005 2C11 82 C0 00              brl   scrollit
1006 2C14 AD B0 1D     contt2   lda   |curcda
1007 2C17 1A                    inc   a                        ;bump to next cda
1008 2C18 CD 7C 1D              cmp   |numdas                  ; if curcda > numdas ->
1009 2C1B 90 05                 bcc   nowrap1
1010 2C1D F0 03                 beq   nowrap1
1011 2C1F
1012 2C1F A9 FF 00              lda   #$FF                     ;set to quit
1013 2C22
1014 2C22 48           nowrap1  pha   
1015 2C23 EE 74 1D              inc   |vpos
1016 2C26 68                    pla   
1017 2C27
1018 2C27 8D B0 1D     drawnam  sta   |curcda                  ; hilight curcda
1019 2C2A A8                    tay   
1020 2C2B A9 FF 00              lda   #$FF
1021 2C2E 20 84 35              jsr   writedaname
1022 2C31
1023 2C31 82 58 FF              brl   loop1                    ; loop again
1024 2C34
1025 2C34              DoPageDown  
1026 2C34              *Apple and the down arrow key were pressed
1027 2C34 AD 80 1D              lda   |firstmenuitem
1028 2C37 18                    clc   
1029 2C38 69 0D 00              adc   #numlines-1              ;this is the number of bottom menu item
1030 2C3B CD B0 1D              cmp   |curcda                  ;is this the selected one?
1031 2C3E F0 1A                 beq   DoPageDown1              ;branch if it is
1032 2C40              *See if its over the end
1033 2C40
1034 2C40 CD 7C 1D              cmp   |numdas                  ;are we off the bottom of the menu?
1035 2C43 F0 05                 beq   DoPageDownOK             ;less than or = to #das
1036 2C45 90 03                 bcc   DoPageDownOK             ;then we're not over the bottom
1037 2C47
1038 2C47 A9 FF 00              lda   #$FF                     ;move to quit if off the end 
1039 2C4A 48           DoPageDownOK pha                        ;if it isn't, select and drawit
1040 2C4B AD 70 1D              lda   |bottomline
1041 2C4E 8D 74 1D              sta   |vpos
1042 2C51 AD 7E 1D              lda   |leftborder
1043 2C54 8D 72 1D              sta   |hpos
1044 2C57 68                    pla                            ;a has curcda
1045 2C58 80 CD                 bra   drawnam
1046 2C5A              DoPageDown1  
1047 2C5A              *We want to page down
1048 2C5A 1A                    inc   a
1049 2C5B 8D 80 1D              sta   |firstmenuitem           ;page down by one
1050 2C5E 18                    clc   
1051 2C5F 69 0D 00              adc   #numlines-1              ;item on new screen bottom
1052 2C62 CD 7C 1D              cmp   |numdas                  ;is it valid
1053 2C65 90 27                 bcc   DoPageD2                 ;it's OK: scroll
1054 2C67 F0 25                 beq   DoPageD2                 ;it's Ok: scroll
1055 2C69              *We went off the bottom.  Make quit the selected item.
1056 2C69 AD 7C 1D              lda   |numdas
1057 2C6C 38                    sec   
1058 2C6D E9 0C 00              sbc   #numlines-2              ;-2 to make room for quit
1059 2C70 B0 03                 bcs   EndOfDown                ;were're ok: branch.  A has new start loc.
1060 2C72
1061 2C72 A9 00 00              lda   #0                       ;less menu items than lines.  Start @ top 
1062 2C75 8D 80 1D     EndOfDown sta   |firstmenuitem
1063 2C78 20 39 33              jsr   UpdateCDAMenu
1064 2C7B A9 FF 00              lda   #$FF                     ;quit item
1065 2C7E 48                    pha   
1066 2C7F AD 7E 1D     EndOfDown1 lda   |leftborder
1067 2C82 8D 72 1D              sta   |hpos
1068 2C85 AD 70 1D              lda   |bottomline
1069 2C88 8D 74 1D              sta   |vpos
1070 2C8B 68                    pla   
1071 2C8C 80 99                 bra   drawnam
1072 2C8E
1073 2C8E              DoPageD2  
1074 2C8E              *Here we just want to scroll down one page (numlines)
1075 2C8E 48                    pha   
1076 2C8F 20 39 33              jsr   UpdateCDAMenu
1077 2C92 80 EB                 bra   EndOfDown1
1078 2C94
1079 2C94              DoPageUp  
1080 2C94              *Apple and the up arrow key were pressed
1081 2C94 A9 04 00              lda   #top
1082 2C97 8D 74 1D              sta   |vpos
1083 2C9A AD 7E 1D              lda   |leftborder
1084 2C9D 8D 72 1D              sta   |hpos
1085 2CA0 AD 80 1D              lda   |firstmenuitem
1086 2CA3 CD B0 1D              cmp   |curcda                  ;are we at the top?
1087 2CA6 F0 06                 beq   JumpUp                   ;branch if we are at top
1088 2CA8 8D B0 1D              sta   |curcda                  ;set to top of screen
1089 2CAB 82 79 FF              brl   drawnam
1090 2CAE
1091 2CAE              JumpUp    
1092 2CAE              *Jump up one page (numlines)
1093 2CAE 38                    sec   
1094 2CAF E9 0E 00              sbc   #NumLines                ;subtract from firstmenuitem
1095 2CB2 90 1B                 bcc   GoToTop                  ;branch if it puts us over the top
1096 2CB4 8D 80 1D     JumpUp1  sta   |firstmenuitem           ;otherwise we move up by one page
1097 2CB7 8D B0 1D              sta   |curcda
1098 2CBA 20 39 33              jsr   UpdateCDAMenu            ;scroll
1099 2CBD A9 04 00              lda   #top                     ;we are at the top
1100 2CC0 8D 74 1D              sta   |vpos
1101 2CC3 AD 7E 1D              lda   |leftborder
1102 2CC6 8D 72 1D              sta   |hpos
1103 2CC9 AD B0 1D              lda   |curcda
1104 2CCC 82 58 FF              brl   drawnam
1105 2CCF A9 00 00     GoToTop  lda   #0
1106 2CD2 80 E0                 bra   JumpUp1
1107 2CD4
1108 2CD4              scrollit  
1109 2CD4              *we are on last line.  Bump da pointer, scoll, then inverse video to select
1110 2CD4 AD B0 1D              lda   |curcda
1111 2CD7 1A                    inc   a
1112 2CD8 CD 7C 1D              cmp   |numdas
1113 2CDB 90 05                 bcc   scrollit1                ;branch if not on last item
1114 2CDD F0 03                 beq   scrollit1
1115 2CDF
1116 2CDF A9 FF 00              lda   #$FF                     ;no more CDA's.  Quit is last item.
1117 2CE2 8D B0 1D     scrollit1 sta   |curcda                 ;we have the new DA number
1118 2CE5 EE 80 1D              inc   |firstmenuitem           ;start display one item later
1119 2CE8 20 39 33              jsr   UpdateCDAMenu
1120 2CEB A9 11 00              lda   #Top+Numlines-1
1121 2CEE 8D 74 1D              sta   |vpos
1122 2CF1 AD 7E 1D              lda   |leftborder
1123 2CF4 8D 72 1D              sta   |hpos
1124 2CF7 AD B0 1D              lda   |curcda
1125 2CFA 82 2A FF              brl   drawnam
1126 2CFD
1127 2CFD C2 30        upaline  longmx 
1128 2CFF
1129 2CFF AC B0 1D              ldy   |curcda                  ; unhighlight current da
1130 2D02 A9 00 00              lda   #$00
1131 2D05 20 84 35              jsr   writedaname
1132 2D08              *move by pages?
1133 2D08 AD 25 C0              lda   |ModKeyReg               ;Modifier key register $c025
1134 2D0B 29 80 00              and   #$0080                   ;apple key bit (page 124 harware ref)
1135 2D0E F0 03                 beq   NoPageUp
1136 2D10 82 81 FF              brl   DoPageUp                 ;jump by pages
1137 2D13
1138 2D13 AD B0 1D     NoPageUp lda   |curcda                  ; if curcda = cntrl pan, wrap
1139 2D16 D0 0C                 bne   cont2
1140 2D18
1141 2D18              *We're at the top (control panel)  Don't wrap.  Do nothing.
1142 2D18 AD 7E 1D              lda   |leftborder
1143 2D1B 8D 72 1D              sta   |hpos
1144 2D1E A9 00 00              lda   #0
1145 2D21 82 03 FF              brl   drawnam
1146 2D24              *We're at the top (control panel)  
1147 2D24
1148 2D24              cont2     
1149 2D24              * not at control panel
1150 2D24              * check if we are at top
1151 2D24 AD 74 1D              lda   |vpos
1152 2D27 C9 04 00              cmp   #top
1153 2D2A F0 12                 beq   scrollup                 ;if we're at the top we need to scroll up
1154 2D2C              ;
1155 2D2C              ;just move up a line; no scrolling necessary.  A contains vpos.
1156 2D2C              ;
1157 2D2C 3A                    dec   a
1158 2D2D 8D 74 1D              sta   |vpos
1159 2D30 AD B0 1D              lda   |curcda
1160 2D33 C9 FF 00              cmp   #$FF
1161 2D36 D0 21                 bne   cont4
1162 2D38 AD 7C 1D              lda   |numdas
1163 2D3B 82 E9 FE              brl   drawnam
1164 2D3E
1165 2D3E              scrollup  
1166 2D3E              * Here we need to scroll up a line.  We know we're not @ the very top because
1167 2D3E              * we weren't @ the control panel
1168 2D3E              * We decrement firstmenuitem & redraw
1169 2D3E CE 80 1D              dec   |firstmenuitem
1170 2D41 CE B0 1D              dec   |curcda
1171 2D44 20 39 33              jsr   UpdateCDAMenu
1172 2D47 A9 04 00              lda   #top
1173 2D4A 8D 74 1D              sta   |vpos
1174 2D4D AD 7E 1D              lda   |leftborder
1175 2D50 8D 72 1D              sta   |hpos
1176 2D53 AD B0 1D              lda   |curcda
1177 2D56 82 CE FE              brl   drawnam
1178 2D59
1179 2D59 3A           cont4    dec   a
1180 2D5A 82 CA FE              brl   drawnam
1181 2D5D
1182 2D5D              DoEscape  
1183 2D5D              *here we select the quit item.
1184 2D5D
1185 2D5D AC B0 1D              ldy   |curcda                  ; unhighlight current da
1186 2D60 A9 00 00              lda   #$00
1187 2D63 20 84 35              jsr   writedaname
1188 2D66              *Goto bottom
1189 2D66              *First calculate new firstmenuitem = numdas-numlines
1190 2D66
1191 2D66              selectquititem  
1192 2D66 AD 7C 1D              lda   |numdas
1193 2D69 38                    sec   
1194 2D6A E9 0C 00              sbc   #numlines-2              ;-2 because 1 for quit and one because
1195 2D6D B0 03                 bcs   selectok
1196 2D6F A9 00 00              lda   #0
1197 2D72 8D 80 1D     selectok sta   |firstmenuitem           ;we start with item 1 (ctrl. panel = 0)
1198 2D75 A9 FF 00              lda   #$FF
1199 2D78 8D B0 1D              sta   |curcda
1200 2D7B 20 39 33              jsr   UpdateCDAMenu
1201 2D7E AD 70 1D              lda   |bottomline
1202 2D81 8D 74 1D              sta   |vpos
1203 2D84 A9 FF 00              lda   #$FF                     ;quit item
1204 2D87 82 9D FE              brl   drawnam
1205 2D8A
1206 2D8A                       ENTRY DONE 
1207 2D8A              done                                    ;       
1208 2D8A E2 30                 shortmx 
1209 2D8C A9 FF                 lda   #$FF
1210 2D8E 85 32                 sta   $000032                  ; inverse flag
1211 2D90 C2 30                 longmx 
1212 2D92
1213 2D92 FA                    plx                            ;get bit encoded slot configuation
1214 2D93 A9 00 03              lda   #$0300
1215 2D96 22 08 02 E1           jsl   Slot_Arbiter             ;restore original configuration
1216 2D9A
1217 2D9A              ;
1218 2D9A              ; Need to unlock table of CDA's (|CDATabHndl) when exiting.  setuptab (called by
1219 2D9A              ; initstuff (below) locked the table.
1220 2D9A              ;
1221 2D9A AD 86 1D              lda   |CDATabHndl+2
1222 2D9D 48                    pha   
1223 2D9E AD 84 1D              lda   |CDATabHndl
1224 2DA1 48                    pha   
1225 2DA2 A2 02 22 22           _HUnlock 
1226 2DA9
1227 2DA9 AB                    plb   
1228 2DAA 5C 0B 1D 02           jml   oendcall0
1229 2DAE                       ENDP 
1230 2DAE
1231 2DAE                       EXPORT initstuff
1232 2DAE              initstuff PROC 
1233 2DAE A9 17 00              lda   #LeftBorder80            ;default init assumes 80 column screen
1234 2DB1 8D 7E 1D              sta   |leftborder
1235 2DB4 A9 14 00              lda   #LeftBorder80-3          ;start position for border of menu
1236 2DB7 8D 72 1D              sta   |hpos
1237 2DBA A9 00 00              lda   #0
1238 2DBD 8D 74 1D              sta   |vpos
1239 2DC0 20 D9 35              jsr   setuptab                 ;sets up table of CDA strings
1240 2DC3 E2 20                 sep   #$20
1241 2DC5                       longa off
1242 2DC5 8F 0D C0 00           sta   >$00C00d
1243 2DC9 8F 01 C0 00           sta   >$00C001
1244 2DCD
1245 2DCD AF 2D C0 00           lda   >$00C02d
1246 2DD1 29 08                 and   #$08
1247 2DD3 D0 06                 bne   NotInternalSlot3
1248 2DD5 A9 00                 lda   #0
1249 2DD7 8F FB 07 00           sta   >$0007FB
1250 2DDB              NotInternalSlot3  
1251 2DDB C2 20                 rep   #$20
1252 2DDD                       longa on
1253 2DDD              ;
1254 2DDD              ; Set up screen holes to the values CDA expect
1255 2DDD              ;
1256 2DDD
1257 2DDD 60                    rts   
1258 2DDE                       ENDP 
1259 2DDE
1260 2DDE              gotreturn PROC EXPORT 
1261 2DDE
1262 2DDE C2 30                 longmx 
1263 2DE0 AD B0 1D              lda   |curcda
1264 2DE3 F0 0B                 beq   conpan
1265 2DE5 C9 FF 00              cmp   #$FF
1266 2DE8 F0 15                 beq   quitcode
1267 2DEA
1268 2DEA 20 FA 35              jsr   openda
1269 2DED 4C 3E 2F              jmp   choosecdaWarm
1270 2DF0
1271 2DF0 E2 30        conpan   shortmx 
1272 2DF2 A9 00                 lda   #$00                     ; set b to bank zero
1273 2DF4 48                    pha   
1274 2DF5 AB                    plb   
1275 2DF6 22 90 00 E1           jsl   toctrl_panel
1276 2DFA C2 30                 longmx 
1277 2DFC 4C 3E 2F              jmp   choosecdaWarm
1278 2DFF
1279 2DFF 4C 8A 32     quitcode jmp   done
1280 2E02
1281 2E02                       ENDP 
1282 2E02
1283 2E02              monkeyin PROC EXPORT 
1284 2E02 E2 30                 shortmx 
1285 2E04
1286 2E04 AD 00 C0              lda   $C000                    ;read keyboard
1287 2E07 10 F9                 bpl   monkeyin                 ;wait for keypress
1288 2E09 8D 10 C0              sta   $C010                    ;acknowledge keypress: clear keyboard
1289 2E0C C2 30                 longmx 
1290 2E0E 60                    rts   
1291 2E0F
1292 2E0F                       ENDP 
1293 2E0F
1294 2E0F                       EXPORT evntkeyin
1295 2E0F              evntkeyin PROC 
1296 2E0F
1297 2E0F F4 00 00              pushword #$00                  ; result
1298 2E12              ***	pushword #$FFFF		;event mask -- keyboard only
1299 2E12 F4 28 04              pushword #$0428                ;keydown and autokey only (12-Feb-91 DAL) + deskAcc (23-Feb-91)
1300 2E15 F4 E0 00              pea   evntrec>>16
1301 2E18 F4 8C 1D              pea   evntrec**$FFFF
1302 2E1B A2 06 0A 22           _GetNextEvent 
1303 2E22 68                    pla   
1304 2E23 F0 EA                 beq   evntkeyin                ; if 0 we don't handle
1305 2E25 AD 8C 1D              lda   |evntrec
1306 2E28 C9 03 00              cmp   #$03
1307 2E2B F0 05                 beq   @1                       ; if keydown then exit
1308 2E2D C9 05 00              cmp   #$05
1309 2E30 D0 DD                 bne   evntkeyin                ; if not autokey then skip
1310 2E32 AD 8E 1D     @1       lda   |message
1311 2E35 29 FF 00              and   #$00FF                   ; make sure we only have bottom byte
1312 2E38 60                    rts   
1313 2E39
1314 2E39                       ENDP 
1315 2E39
1316 2E39              **********************************************************************
1317 2E39              *
1318 2E39              * This routine displays the CDAs
1319 2E39              *
1320 2E39              * The Pascal string list of CDA names is assumed to be setup already
1321 2E39              *
1322 2E39              * The first DA shown is in |firstmenuitem (0 = first one = Control Panel)
1323 2E39              *
1324 2E39              * |numdas contains the number of CDAs in the list
1325 2E39              *
1326 2E39              * This routine is called at the beginning and everytime the display 
1327 2E39              * scrolls.
1328 2E39              *
1329 2E39              * Added by Konstantin Othmer Sept 21, 1988
1330 2E39              *
1331 2E39              ****************************************************************
1332 2E39                       EXPORT UpdateCDAMenu
1333 2E39              UpdateCDAMenu PROC 
1334 2E39              * Set cursor to first location.
1335 2E39 AD 7E 1D              lda   |leftborder
1336 2E3C 8D 72 1D              sta   |hpos
1337 2E3F A9 03 00              lda   #Top-1                   ;vertical text start position  
1338 2E42 8D 74 1D              sta   |vpos
1339 2E45
1340 2E45              ;
1341 2E45              ; check if jumper is in
1342 2E45              ; force it in for testing purposes
1343 2E45              ;
1344 2E45 20 48 36              jsr   panelactive
1345 2E48 90 15                 bcc   test2                    ;panel active => goto test2
1346 2E4A              ;
1347 2E4A              ;control panel not active - force firstmenuitem to 1 if it is 0 and same with curcda
1348 2E4A              ;
1349 2E4A AD B0 1D              lda   |curcda
1350 2E4D D0 07                 bne   test1
1351 2E4F 1A                    inc   a
1352 2E50 8D B0 1D              sta   |curcda
1353 2E53 8D 80 1D              sta   |firstmenuitem
1354 2E56 AD 80 1D     test1    lda   |firstmenuitem
1355 2E59 D0 04                 bne   test2
1356 2E5B 1A                    inc   a
1357 2E5C 8D 80 1D              sta   |firstmenuitem
1358 2E5F              test2     
1359 2E5F
1360 2E5F              * If we are at item 0, print a blank line and 'control panel'
1361 2E5F
1362 2E5F AD 80 1D              lda   |firstmenuitem
1363 2E62 D0 3A                 bne   Update0
1364 2E64
1365 2E64              *We're @ top.  Blank uparrows if they are there by drawing blank line
1366 2E64
1367 2E64 A9 2D 02              lda   #>blankline
1368 2E67 85 41                 sta   temp2+1
1369 2E69 A9 E8 2D              lda   #<blankline
1370 2E6C 85 40                 sta   temp2
1371 2E6E 20 35 35              jsr   MyWriteCString
1372 2E71
1373 2E71 AD 7E 1D              lda   |leftborder
1374 2E74 8D 72 1D              sta   |hpos
1375 2E77 EE 74 1D              inc   |vpos
1376 2E7A
1377 2E7A A9 2D 02              lda   #>blankline              ;blank control panel line to the end
1378 2E7D 85 41                 sta   temp2+1
1379 2E7F A9 E8 2D              lda   #<blankline
1380 2E82 85 40                 sta   temp2
1381 2E84 20 35 35              jsr   MyWriteCString
1382 2E87
1383 2E87 AD 7E 1D              lda   |leftborder
1384 2E8A 8D 72 1D              sta   |hpos
1385 2E8D A9 00 00              lda   #0                       ;normal text
1386 2E90 A0 00 00              ldy   #0                       ;control panel
1387 2E93 20 84 35              jsr   writedaname              ;print control panel: item 0
1388 2E96 EE 74 1D              inc   |vpos
1389 2E99 A0 01 00              ldy   #1                       ;y-reg contains number of 1st item to do
1390 2E9C 80 35                 bra   Update1
1391 2E9E              Update0   
1392 2E9E              ;not at top.  print up arrows @ top-1
1393 2E9E              ;
1394 2E9E              ; If control panel enabled => goto test3
1395 2E9E              ;
1396 2E9E 20 48 36              jsr   panelactive
1397 2EA1 90 17                 bcc   test3
1398 2EA3              ;
1399 2EA3              ; control panel not enabled: skip arrows when 1,1
1400 2EA3              ;
1401 2EA3 AD 80 1D              lda   |firstmenuitem
1402 2EA6 C9 01 00              cmp   #1
1403 2EA9 D0 0F                 bne   test3
1404 2EAB              ;
1405 2EAB              ; Blank uparrows line
1406 2EAB              ;
1407 2EAB A9 2D 02              lda   #>blankline
1408 2EAE 85 41                 sta   temp2+1
1409 2EB0 A9 E8 2D              lda   #<blankline
1410 2EB3 85 40                 sta   temp2
1411 2EB5 20 35 35              jsr   MyWriteCString
1412 2EB8 80 0D                 bra   test4
1413 2EBA
1414 2EBA              test3     
1415 2EBA A9 2D 02              lda   #>uparrows
1416 2EBD 85 41                 sta   temp2+1
1417 2EBF A9 DB 2D              lda   #<uparrows
1418 2EC2 85 40                 sta   temp2
1419 2EC4 20 6B 35              jsr   MyWriteCStringnt
1420 2EC7              test4     
1421 2EC7 AD 7E 1D              lda   |leftborder
1422 2ECA 8D 72 1D              sta   |hpos
1423 2ECD EE 74 1D              inc   |vpos
1424 2ED0 AC 80 1D              ldy   |firstmenuitem
1425 2ED3              Update1   
1426 2ED3 A9 00 00              lda   #0
1427 2ED6 48                    pha                            ;set up flag for quit item
1428 2ED7 AD 7C 1D              lda   |numdas                  ;calculate number of items to print
1429 2EDA
1430 2EDA              *number of items to print is numdas - firstmenuitem +1
1431 2EDA
1432 2EDA 38                    sec                            ;x-reg will contain number of items to do
1433 2EDB ED 80 1D              sbc   |firstmenuitem
1434 2EDE AA                    tax   
1435 2EDF AD 80 1D              lda   |firstmenuitem           ;Did we do control panel (above)?
1436 2EE2 D0 11                 bne   Update2                  ;If we didn't, branch.
1437 2EE4
1438 2EE4              *This section assumes control panel done.
1439 2EE4
1440 2EE4
1441 2EE4 E0 0C 00              cpx   #NumLines-2              ;Control panel and quit each take up one line
1442 2EE7 90 1A                 bcc   Update4                  ;If 13 or less, there is quit item: branch
1443 2EE9 F0 18                 beq   Update4
1444 2EEB A2 0D 00              ldx   #NumLines-1              ;print maximum w/ control panel & no quit
1445 2EEE A9 FF FF              lda   #$ffff                   ;signal no quit item
1446 2EF1 83 01                 sta   1,s
1447 2EF3 80 0E                 bra   Update4
1448 2EF5              Update2   
1449 2EF5              * No Control Panel
1450 2EF5 E8                    inx   
1451 2EF6 E0 0E 00              cpx   #NumLines                ;Total length of display
1452 2EF9 90 08                 bcc   Update4                  ;branch on 14 or less
1453 2EFB A2 0E 00              ldx   #NumLines                ;print maximum w/o control panel & no quit
1454 2EFE A9 FF FF              lda   #$ffff                   ;signal no quit item
1455 2F01 83 01                 sta   1,s
1456 2F03
1457 2F03              Update4   
1458 2F03 20 6A 34              jsr   PrintDAList              ;Print list of DAs
1459 2F06              * Handle Quit Item
1460 2F06 AD 7E 1D              lda   |leftborder
1461 2F09 8D 72 1D              sta   |hpos
1462 2F0C 68                    pla                            ;$ff signals no quit item, 0 signals quit
1463 2F0D D0 3A                 bne   DoDownArrows
1464 2F0F
1465 2F0F AD 70 1D              lda   |bottomline
1466 2F12 8D 74 1D              sta   |vpos
1467 2F15 AD 7E 1D              lda   |leftborder
1468 2F18 8D 72 1D              sta   |hpos
1469 2F1B
1470 2F1B A9 2D 02              lda   #>blankline
1471 2F1E 85 41                 sta   temp2+1
1472 2F20 A9 E8 2D              lda   #<blankline
1473 2F23 85 40                 sta   temp2
1474 2F25 20 35 35              jsr   MyWriteCString
1475 2F28
1476 2F28 AD 7E 1D              lda   |leftborder
1477 2F2B 8D 72 1D              sta   |hpos
1478 2F2E A9 00 00              lda   #0                       ; normal
1479 2F31 A0 FF 00              ldy   #$FF                     ;quit item identification
1480 2F34 20 84 35              jsr   writedaname
1481 2F37
1482 2F37              * Here we erase bottom row.  It may contain down arrows which we don't want.
1483 2F37 EE 74 1D              inc   |vpos
1484 2F3A
1485 2F3A A9 2D 02              lda   #>blankline
1486 2F3D 85 41                 sta   temp2+1
1487 2F3F A9 E8 2D              lda   #<blankline
1488 2F42 85 40                 sta   temp2
1489 2F44 20 35 35              jsr   MyWriteCString
1490 2F47
1491 2F47 80 20                 bra   UpdateDone
1492 2F49              DoDownArrows  
1493 2F49              ;
1494 2F49              ; There is no quit item, so there must be more.  A "*** more ***" message shows this.
1495 2F49              ;
1496 2F49 A9 2D 02              lda   #>blankline
1497 2F4C 85 41                 sta   temp2+1
1498 2F4E A9 E8 2D              lda   #<blankline
1499 2F51 85 40                 sta   temp2
1500 2F53 20 35 35              jsr   MyWriteCString
1501 2F56
1502 2F56 AD 7E 1D              lda   |leftborder
1503 2F59 8D 72 1D              sta   |hpos
1504 2F5C
1505 2F5C A9 2D 02              lda   #>downarrows
1506 2F5F 85 41                 sta   temp2+1
1507 2F61 A9 DB 2D              lda   #<downarrows
1508 2F64 85 40                 sta   temp2
1509 2F66 20 6B 35              jsr   MyWriteCStringnt
1510 2F69
1511 2F69
1512 2F69              UpdateDone  
1513 2F69 60                    rts   
1514 2F6A                       ENDP 
1515 2F6A
1516 2F6A
1517 2F6A              **********************************************************************
1518 2F6A              *
1519 2F6A              * PrintDAList
1520 2F6A              *
1521 2F6A              *  Prints an excerpt from a list of C-strings
1522 2F6A              *
1523 2F6A              * y-reg has # of 1st item to print (list starts at 1)
1524 2F6A              * x-reg has # of items to print
1525 2F6A              *
1526 2F6A              * Routine assumes initial print location is set up 
1527 2F6A              *
1528 2F6A              * Everything printed in normal (not inverse) type
1529 2F6A              *
1530 2F6A              * Added by Konstantin Othmer Sept 21, 1988
1531 2F6A              *
1532 2F6A              **********************************************************************
1533 2F6A                       EXPORT PrintDAList
1534 2F6A              PrintDAList PROC 
1535 2F6A E8                    inx   
1536 2F6B CA           PrintC1  dex                            ;Number items left zero?
1537 2F6C F0 36                 beq   PrintCDone
1538 2F6E DA                    phx   
1539 2F6F 5A                    phy   
1540 2F70
1541 2F70 AD 7E 1D              lda   |leftborder
1542 2F73 8D 72 1D              sta   |hpos
1543 2F76 7A                    ply   
1544 2F77 5A                    phy   
1545 2F78 A9 00 00              lda   #0                       ;normal
1546 2F7B 20 84 35              jsr   writedaname              ;does not change |hpos
1547 2F7E 18                    clc                            ;a-reg contains length of da string
1548 2F7F 6D 72 1D              adc   |hpos
1549 2F82 8D 72 1D              sta   |hpos
1550 2F85
1551 2F85              PrintLoop  
1552 2F85 AD 7E 1D              lda   |leftborder
1553 2F88 18                    clc   
1554 2F89 69 24 00              adc   #36                      ;screen width
1555 2F8C CD 72 1D              cmp   |hpos                    ;have we filled to the right border yet?
1556 2F8F F0 0B                 beq   LoopDone
1557 2F91 A9 A0 00              lda   #' '
1558 2F94 20 BB 34              jsr   Mycout                   ;blank char
1559 2F97 EE 72 1D              inc   |hpos
1560 2F9A 80 E9                 bra   PrintLoop
1561 2F9C
1562 2F9C              LoopDone  
1563 2F9C EE 74 1D              inc   |vpos                    ;advance vertical position
1564 2F9F 7A                    ply   
1565 2FA0 FA                    plx   
1566 2FA1 C8                    iny   
1567 2FA2 80 C7                 bra   PrintC1
1568 2FA4 60           PrintCDone rts   
1569 2FA5                       ENDP 
1570 2FA5
1571 2FA5              **********************************************************************
1572 2FA5              *
1573 2FA5              * Sends character in a to $FDED
1574 2FA5              *
1575 2FA5              ****************************************************************
1576 2FA5                       EXPORT cout
1577 2FA5              cout     PROC 
1578 2FA5
1579 2FA5
1580 2FA5              ;	pea	00	; space for result
1581 2FA5              ;	pea	00	; space for result
1582 2FA5              ;	pea	00	; space for result
1583 2FA5              ;	pea	00	; space for result
1584 2FA5 48                    pha                            ; space for result (DAL)
1585 2FA6 48                    pha                            ; space for result (DAL)
1586 2FA7 48                    pha                            ; space for result (DAL)
1587 2FA8 48                    pha                            ; space for result (DAL)
1588 2FA9 48                    pha                            ; acc at entry
1589 2FAA              ;	pea	00	; xreg at entry
1590 2FAA              ;	pea	00	; yreg at entry
1591 2FAA 48                    pha                            ; xreg at entry (DAL)
1592 2FAB 48                    pha                            ; yreg at entry (DAL)
1593 2FAC F4 ED FD              pea   $FDED
1594 2FAF A2 03 24 22           _FWEntry 
1595 2FB6 68                    pla   
1596 2FB7 68                    pla   
1597 2FB8 68                    pla   
1598 2FB9 68                    pla   
1599 2FBA
1600 2FBA 60                    rts   
1601 2FBB                       ENDP 
1602 2FBB
1603 2FBB              **********************************************************************
1604 2FBB              *
1605 2FBB              * Screen driver:  A-reg contains character to print
1606 2FBB              *
1607 2FBB              **********************************************************************
1608 2FBB                       EXPORT MyCout
1609 2FBB              MyCout   PROC 
1610 2FBB 29 FF 00              and   #$00FF
1611 2FBE 48                    pha                            ;save character to print
1612 2FBF 20 90 36              jsr   SetScreenLoc
1613 2FC2 AE 76 1D              ldx   |CurScreenLoc
1614 2FC5 E0 00 04              cpx   #$400
1615 2FC8 B0 0F                 bcs   DoBank1
1616 2FCA BF 00 04 00           lda   >$400,x                  ;screen
1617 2FCE 29 00 FF              and   #$FF00
1618 2FD1 03 01                 ora   1,s
1619 2FD3 9F 00 04 00           sta   >$400,x
1620 2FD7 80 12                 bra   Bank0Done
1621 2FD9              DoBank1   
1622 2FD9 8A                    txa   
1623 2FDA 29 FF 03              and   #$03FF
1624 2FDD AA                    tax   
1625 2FDE BF 00 04 01           lda   >$010400,x               ;screen
1626 2FE2 29 00 FF              and   #$FF00
1627 2FE5 03 01                 ora   1,s
1628 2FE7 9F 00 04 01           sta   >$010400,x
1629 2FEB              Bank0Done  
1630 2FEB 68                    pla   
1631 2FEC 60                    rts   
1632 2FED
1633 2FED                       ENDP 
1634 2FED
1635 2FED              **********************************************************************
1636 2FED              *
1637 2FED              * Faster writeline routine.  Uses MyCout.
1638 2FED              *
1639 2FED              *  Assumes pointer to p-string is in temp2
1640 2FED              *
1641 2FED              **********************************************************************
1642 2FED                       EXPORT MyWriteLine
1643 2FED              MyWriteLine PROC 
1644 2FED
1645 2FED A7 40                 lda   [temp2]
1646 2FEF 29 3F 00              and   #$3f                     ;get string length
1647 2FF2 1A                    inc   a                        ;offset because compare is done before print
1648 2FF3 48                    pha   
1649 2FF4 A0 01 00              ldy   #1
1650 2FF7 B7 40        PrintLoop lda   [temp2],y
1651 2FF9              *** added 30-Sep-91 DAL -- support Ctrl-N for normal video
1652 2FF9 29 7F 00              and   #$007f
1653 2FFC C9 0E 00              cmp   #$000E
1654 2FFF D0 0C                 bne   @notCtrlN
1655 3001 E2 20                 sep   #$20
1656 3003                       longa off
1657 3003 A9 FF                 lda   #$FF
1658 3005 8F 32 00 00           sta   >$32
1659 3009 C2 20                 rep   #$20
1660 300B                       longa on
1661 300B 80 20                 bra   Did1Character
1662 300D              @notCtrlN  
1663 300D              *** end 30-Sep-91 DAL
1664 300D 24 31                 bit   $000031                  ;bit 7 of inverse flag
1665 300F 30 11                 bmi   NormalVideo
1666 3011
1667 3011 29 7F 00              and   #$7F
1668 3014 48                    pha   
1669 3015              ;
1670 3015              ;check for upper case inverse text
1671 3015              ;
1672 3015 29 20 00              and   #$20
1673 3018 D0 05                 bne   ItsLowerCase
1674 301A 68                    pla   
1675 301B 29 BF 00              and   #$BF                     ;reset bit 6
1676 301E 48                    pha   
1677 301F
1678 301F              ItsLowerCase  
1679 301F 68                    pla   
1680 3020 80 03                 bra   DoVideo
1681 3022              NormalVideo  
1682 3022 09 80 00              ora   #$80
1683 3025              DoVideo   
1684 3025 5A                    phy   
1685 3026 20 BB 34              jsr   Mycout
1686 3029 EE 72 1D              inc   |hpos
1687 302C 7A                    ply   
1688 302D C8           Did1Character iny   
1689 302E 98                    tya   
1690 302F C3 01                 cmp   1,s
1691 3031 D0 C4                 bne   PrintLoop
1692 3033 68                    pla                            ;clear stack
1693 3034 60                    rts   
1694 3035                       ENDP 
1695 3035
1696 3035              **********************************************************************
1697 3035              *
1698 3035              * Faster writeCString routine.  Uses MyCout.
1699 3035              *
1700 3035              *  Assumes pointer to p-string is in temp2
1701 3035              *
1702 3035              ****************************************************************
1703 3035                       EXPORT MyWriteCString
1704 3035              MyWriteCString PROC 
1705 3035
1706 3035 AE 72 1D              ldx   |hpos
1707 3038 DA                    phx   
1708 3039
1709 3039              Translate  
1710 3039 A0 00 00              ldy   #0
1711 303C              PrintLoop  
1712 303C B7 40                 lda   [temp2],y
1713 303E 29 FF 00              and   #$FF
1714 3041 F0 23                 beq   Done
1715 3043 24 31                 bit   $000031                  ;bit 7 of inverse flag
1716 3045 30 11                 bmi   NormalVideo
1717 3047
1718 3047 29 7F 00              and   #$7F
1719 304A 48                    pha   
1720 304B              ;
1721 304B              ;check for upper case inverse text
1722 304B              ;
1723 304B 29 20 00              and   #$20
1724 304E D0 05                 bne   ItsLowerCase
1725 3050 68                    pla   
1726 3051 29 BF 00              and   #$BF                     ;reset bit 6
1727 3054 48                    pha   
1728 3055
1729 3055              ItsLowerCase  
1730 3055 68                    pla   
1731 3056 80 03                 bra   DoVideo
1732 3058              NormalVideo  
1733 3058 09 80 00              ora   #$80
1734 305B              DoVideo   
1735 305B 5A                    phy   
1736 305C 20 BB 34              jsr   Mycout
1737 305F EE 72 1D              inc   |hpos
1738 3062 7A                    ply   
1739 3063 C8                    iny   
1740 3064 80 D6                 bra   PrintLoop
1741 3066
1742 3066 FA           Done     plx   
1743 3067 8E 72 1D              stx   |hpos
1744 306A 60                    rts   
1745 306B              ;
1746 306B              ; don't translate characters
1747 306B              ;
1748 306B                       EXPORT MyWriteCStringnt
1749 306B              MyWriteCStringnt  
1750 306B AE 72 1D              ldx   |hpos
1751 306E DA                    phx   
1752 306F A0 00 00              ldy   #0
1753 3072              NoTLoop   
1754 3072 B7 40                 lda   [temp2],y
1755 3074 29 FF 00              and   #$FF
1756 3077 F0 ED                 beq   Done
1757 3079 5A                    phy   
1758 307A 20 BB 34              jsr   Mycout
1759 307D EE 72 1D              inc   |hpos
1760 3080 7A                    ply   
1761 3081 C8                    iny   
1762 3082 80 EE                 bra   NoTLoop
1763 3084
1764 3084                       ENDP 
1765 3084
1766 3084              ;-----------------------------------------------------------
1767 3084              ; Write the name of the da corresponding to the number in the y
1768 3084              ; register at the current cursor position. If the accumulator is zero
1769 3084              ; then the item is drawn in 'normal' mode. If non-zero, the name is
1770 3084              ; displayed in inverse mode. Note that the routine assumes that
1771 3084              ; cdatabptr is valid and cdatab is locked.
1772 3084
1773 3084                       EXPORT writedaname
1774 3084              writedaname PROC 
1775 3084
1776 3084 C9 00 00              cmp   #$00
1777 3087 D0 06                 bne   inverse
1778 3089
1779 3089 E2 30                 shortmx 
1780 308B A9 FF                 lda   #$FF
1781 308D              ;;;	sta	$000032	; clear the inverse flag
1782 308D              ;;;	longmx
1783 308D 80 04                 bra   cont
1784 308F
1785 308F E2 30        inverse  shortmx 
1786 3091 A9 7F                 lda   #$7F
1787 3093 85 32        cont     sta   $000032                  ; set the inverse flag
1788 3095 C2 30                 longmx 
1789 3097
1790 3097              ;;;cont
1791 3097 C0 00 00              cpy   #$00
1792 309A D0 05                 bne   cont1
1793 309C
1794 309C A0 06 00              ldy   #$06                     ; offset to control panel string
1795 309F              ;;;	jsr	drbltin	; write the string
1796 309F              ;;;	rts
1797 309F 80 1E                 bra   drbltin
1798 30A1
1799 30A1 C0 FF 00     cont1    cpy   #$FF
1800 30A4 D0 05                 bne   cont2
1801 30A6
1802 30A6 A0 0A 00              ldy   #$0A                     ; offset to quit string
1803 30A9              ;;;	jsr	drbltin
1804 30A9              ;;;	rts
1805 30A9 80 14                 bra   drbltin
1806 30AB
1807 30AB 20 9D 37     cont2    jsr   DerefCDAy                ;made subroutine 12-Feb-91 DAL
1808 30AE
1809 30AE AD 72 1D              lda   |hpos
1810 30B1 48                    pha   
1811 30B2 20 ED 34              jsr   MyWriteline
1812 30B5 68                    pla   
1813 30B6 8D 72 1D              sta   |hpos
1814 30B9 A7 40                 lda   [temp2]                  ;length of string
1815 30BB 29 3F 00              and   #$3f                     ;only byte long
1816 30BE 60                    rts   
1817 30BF
1818 30BF 5A           drbltin  phy   
1819 30C0 AD AC 1D              lda   |dastrptr                ; high part
1820 30C3 85 3C                 sta   temp1
1821 30C5 AD AE 1D              lda   |dastrptr+2              ; lo part
1822 30C8 85 3E                 sta   temp1+2
1823 30CA 7A                    ply   
1824 30CB B7 3C                 lda   [temp1],y
1825 30CD 85 42                 sta   temp2+2
1826 30CF 88                    dey   
1827 30D0 88                    dey   
1828 30D1 B7 3C                 lda   [temp1],y
1829 30D3 85 40                 sta   temp2
1830 30D5 20 35 35              jsr   MyWriteCString
1831 30D8 60                    rts   
1832 30D9
1833 30D9                       ENDP 
1834 30D9
1835 30D9              ; set up cdatabptr and lock the table
1836 30D9
1837 30D9                       EXPORT setuptab
1838 30D9              setuptab PROC 
1839 30D9
1840 30D9 AD 86 1D              lda   |CDATabHndl+2
1841 30DC 48                    pha   
1842 30DD 85 3E                 sta   temp1+2
1843 30DF AD 84 1D              lda   |CDATabHndl
1844 30E2 48                    pha   
1845 30E3 85 3C                 sta   temp1
1846 30E5 A2 02 20 22           _HLock 
1847 30EC 20 3C 36              jsr   deref
1848 30EF A5 40                 lda   temp2
1849 30F1 8D A8 1D              sta   |cdatabptr
1850 30F4 A5 42                 lda   temp2+2
1851 30F6 8D AA 1D              sta   |cdatabptr+2
1852 30F9
1853 30F9 60                    rts   
1854 30FA                       ENDP 
1855 30FA
1856 30FA              **********************************************************************
1857 30FA                       EXPORT openda
1858 30FA              openda   PROC 
1859 30FA
1860 30FA 78                    sei   
1861 30FB A8                    tay   
1862 30FC E2 30                 shortmx 
1863 30FE A9 FF                 lda   #$FF
1864 3100 85 32                 sta   $000032                  ; clear the inverse flag
1865 3102 C2 30                 longmx 
1866 3104
1867 3104 AD A8 1D              lda   |cdatabptr               ; copy the table pointer into
1868 3107 85 40                 sta   temp2                    ; the direct page
1869 3109 AD AA 1D              lda   |cdatabptr+2
1870 310C 85 42                 sta   temp2+2
1871 310E 98                    tya   
1872 310F 3A                    dec   a
1873 3110 0A                    asl   a                        ; adjust y
1874 3111 0A                    asl   a
1875 3112 A8                    tay   
1876 3113 B7 40                 lda   [temp2],y                ; get a handle to the da
1877 3115 85 3C                 sta   temp1
1878 3117 C8                    iny   
1879 3118 C8                    iny   
1880 3119 B7 40                 lda   [temp2],y
1881 311B 85 3E                 sta   temp1+2
1882 311D 20 3C 36              jsr   deref                    ; deref the handle
1883 3120 A7 40                 lda   [temp2]                  ; get the length
1884 3122 29 FF 00              and   #$00FF
1885 3125 A8                    tay   
1886 3126 C8                    iny   
1887 3127 4B                    phk                            ; set up return address
1888 3128 62 0F 00              per   ret-1
1889 312B B7 40                 lda   [temp2],y                ; get low part of open addr
1890 312D AA                    tax                            ; save
1891 312E C8                    iny   
1892 312F C8                    iny   
1893 3130 B7 40                 lda   [temp2],y                ; get high part
1894 3132 E2 20                 sep   #$20                     ; 8-bit m
1895 3134 48                    pha                            ; push bank info
1896 3135 C2 30                 rep   #$30
1897 3137 CA                    dex   
1898 3138 DA                    phx                            ; push open address
1899 3139
1900 3139 58                    cli                            ; enable interrupts for the da
1901 313A 6B                    rtl                            ; call the routine
1902 313B 60           ret      rts                            ; all done
1903 313C
1904 313C                       ENDP 
1905 313C
1906 313C                       EXPORT deref
1907 313C              deref    PROC 
1908 313C A0 02 00              ldy   #$02
1909 313F A7 3C                 lda   [temp1]
1910 3141 85 40                 sta   temp2
1911 3143 B7 3C                 lda   [temp1],y
1912 3145 85 42                 sta   temp2+2
1913 3147 60                    rts   
1914 3148                       ENDP 
1915 3148
1916 3148              **********************************************************************
1917 3148              *
1918 3148              * PanelActive
1919 3148              *
1920 3148              *  Checks whether or not to display the control panel.  This is set
1921 3148              * via a jumper on the board.  The jumper controls bit 7 of $00C046.  If
1922 3148              * bit 7 of $00C046 = 0 then we show the control panel and return with the 
1923 3148              * carry clear.  Otherwise the carry is set.
1924 3148              * 
1925 3148              *
1926 3148              PanelActive PROC EXPORT 
1927 3148 48                    pha   
1928 3149 DA                    phx   
1929 314A 5A                    phy   
1930 314B
1931 314B              *** added 7-Jul-92 DAL -- For ROM 1, there is no Control Panel Disable jumper
1932 314B 48                    pha   
1933 314C 48                    pha   
1934 314D 48                    pha   
1935 314E 48                    pha                            ;space for results
1936 314F 48                    pha   
1937 3150 48                    pha   
1938 3151 48                    pha                            ;A, X, Y (who cares)
1939 3152 F4 1F FE              pea   $FE1F
1940 3155 A2 03 24 22           _FWEntry 
1941 315C 7A                    ply                            ;Y value
1942 315D FA                    plx                            ;X value
1943 315E 68                    pla                            ;A value
1944 315F 68                    pla                            ;P value
1945 3160 C0 03 00              cpy   #3                       ;Is this ROM 3?
1946 3163 D0 22                 bne   PanelShow
1947 3165              *** end 7-Jul-92
1948 3165
1949 3165 F4 E1 00 F4           pushlong #IsPanelActive 
1950 316B F4 02 00 F4           pushlong #ReadLocation 
1951 3171 F4 09 00              pea   $0009                    ;read location and store result at IsPanelActive
1952 3174 A2 09 0B 22           _ReadKeyMicroMemory 
1953 317B
1954 317B AF A5 01 E1           lda   >IsPanelActive
1955 317F 29 40 00              and   #$0040                   ;save bit 6
1956 3182 F0 03                 beq   PanelShow
1957 3184 38                    sec                            ;don't show control panel
1958 3185 80 01                 bra   PanelDone
1959 3187
1960 3187 18           PanelShow clc                           ;show control panel
1961 3188              PanelDone  
1962 3188 7A                    ply   
1963 3189 FA                    plx   
1964 318A 68                    pla   
1965 318B 60                    rts   
1966 318C
1967 318C E8 00 00 00  ReadLocation DC L:$00E8                 ;key micro $E8 bit 6 has control panel jumper
1968 3190
1969 3190                       ENDP 
1970 3190
1971 3190              **********************************************************************
1972 3190              *
1973 3190              * Sets SetScreenLoc to position specified in Hpos and Vpos.  Uses MyCout.
1974 3190              *
1975 3190              ****************************************************************
1976 3190                       EXPORT SetScreenLoc
1977 3190              SetScreenLoc PROC 
1978 3190              ;
1979 3190              ;Calculate starting position.  Lookup ypos start and then add xpos
1980 3190              ;
1981 3190 AD 74 1D              lda   |Vpos
1982 3193 0A                    asl   a
1983 3194 AA                    tax   
1984 3195 BF CA 36 02           lda   >ScreenTab,x             ;get starting screen location
1985 3199
1986 3199 8D 76 1D              sta   |CurScreenLoc
1987 319C AD 7E 1D              lda   |Leftborder
1988 319F C9 04 00              cmp   #4                       ;if less than 4, then 40 column mode
1989 31A2 90 1B                 bcc   FortyColumn
1990 31A4              ;
1991 31A4              ; Do 80 column stuff.
1992 31A4              ;
1993 31A4
1994 31A4 AD 72 1D              lda   |Hpos
1995 31A7 48                    pha   
1996 31A8 4A                    lsr   a
1997 31A9 18                    clc   
1998 31AA 6D 76 1D              adc   |CurScreenLoc
1999 31AD 8D 76 1D              sta   |CurScreenLoc
2000 31B0 68                    pla   
2001 31B1 4A                    lsr   a                        ;odd or even position?
2002 31B2 B0 09                 bcs   OnBank0
2003 31B4 AD 76 1D              lda   |CurScreenLoc
2004 31B7 09 00 04              ora   #$400
2005 31BA 8D 76 1D              sta   |CurScreenLoc
2006 31BD              OnBank0   
2007 31BD 80 0A                 bra   AllDone
2008 31BF AD 72 1D     FortyColumn lda   |Hpos
2009 31C2 18                    clc   
2010 31C3 6D 76 1D              adc   |CurScreenLoc
2011 31C6 8D 76 1D              sta   |CurScreenLoc
2012 31C9 60           AllDone  rts   
2013 31CA
2014 31CA 00 00 80 00  ScreenTab DC W:$000,$080,$100,$180,$200,$280,$300,$380
2015 31DA 28 00 A8 00           DC W:$028,$0A8,$128,$1A8,$228,$2A8,$328,$3A8
2016 31EA 50 00 D0 00           DC W:$050,$0D0,$150,$1D0,$250,$2D0,$350,$3D0
2017 31FA
2018 31FA                       ENDP 
2019 31FA
2020 31FA              **********************************************************************
2021 31FA              *
2022 31FA              * SearchCDALetter -- move to the next CDA starting with the
2023 31FA              *                    specified character (in A)
2024 31FA              *
2025 31FA              * (The current selection has already been unhilited, and the
2026 31FA              * caller will hilite the new one when we get back.  We need
2027 31FA              * to return a valid curcda and firstmenuitem, and if we scroll
2028 31FA              * we need to call UpdateCDAMenu in here.)
2029 31FA              *
2030 31FA              **********************************************************************
2031 31FA              SearchCDALetter proc export 
2032 31FA 20 7D 37              jsr   upcase
2033 31FD 48                    pha                            ;keep target value at 1,s
2034 31FE AE 7C 1D              ldx   |numdas
2035 3201 E8                    inx   
2036 3202 E8                    inx   
2037 3203
2038 3203 AC B0 1D              ldy   |curCDA
2039 3206 20 8E 37     @find    jsr   NextCDAy
2040 3209 20 63 37              jsr   GetCDALetterY
2041 320C C3 01                 cmp   1,s
2042 320E F0 0F                 beq   @gotIt
2043 3210 CA                    dex   
2044 3211 D0 F3                 bne   @find
2045 3213
2046 3213 F4 08 80              pea   $8008                    ;bad keypress, default to silence
2047 3216 A2 03 38 22           _SysBeep2 
2048 321D 68           @exit    pla                            ;remove target value from stack
2049 321E 60                    rts   
2050 321F
2051 321F 8C B0 1D     @gotIt   sty   |curcda
2052 3222 20 56 37              jsr   GetCDANum                ;Quit=NumDAs+1
2053 3225              *** If current item is less than first menu item, it's invalid.
2054 3225 CD 80 1D              cmp   |FirstMenuItem
2055 3228 90 09                 bcc   @RecalcFirst
2056 322A
2057 322A              *** If current item is greater than or equal to first item + NumLines,
2058 322A              *** it's invalid.  In other words, if current item minus NumLines is
2059 322A              *** greater than or equal to first item, current item is invalid (signed
2060 322A              *** comparison).
2061 322A 38                    sec   
2062 322B E9 0E 00              sbc   #NumLines
2063 322E CD 80 1D              cmp   |FirstMenuItem
2064 3231 30 EA                 bmi   @exit                    ;no problem
2065 3233              *
2066 3233              * RecalcFirst--current item is out of range, so we need to figure out
2067 3233              * a good place to scroll to.
2068 3233              *
2069 3233 9C 80 1D     @RecalcFirst stz   |FirstMenuItem       ;anticipate scrolling to the top
2070 3236 20 56 37              jsr   GetCDANum                ;Quit=NumDAs+1
2071 3239 E9 0B 00              sbc   #NumLines-3              ;why 3?  It works.
2072 323C 90 13                 bcc   @scrollTheThing          ;scroll to the top
2073 323E F0 11                 beq   @scrollTheThing
2074 3240
2075 3240 8D 80 1D              sta   |FirstMenuItem
2076 3243
2077 3243 AD B0 1D              lda   |curcda
2078 3246 C9 FF 00              cmp   #$ff                     ;Quit?  Force to bottom.
2079 3249 D0 06                 bne   @scrollTheThing
2080 324B CE 80 1D              dec   |FirstMenuItem
2081 324E CE 80 1D              dec   |FirstMenuItem
2082 3251
2083 3251 20 39 33     @scrollTheThing jsr   UpdateCDAMenu
2084 3254 80 C7                 bra   @exit
2085 3256
2086 3256              *
2087 3256              * GetCDANum--return curcda, with $FF (Quit) translated into NumDAs+1
2088 3256              *
2089 3256                       export GetCDANum 
2090 3256 AD B0 1D     GetCDANum lda   |curcda
2091 3259 C9 FF 00              cmp   #$00ff                   ;translate $FF (Quit) into NumDAs+1
2092 325C D0 04                 bne   @1
2093 325E AD 7C 1D              lda   |numdas
2094 3261 1A                    inc   a
2095 3262 60           @1       rts   
2096 3263
2097 3263              *
2098 3263              * GetCDALetterY
2099 3263              *
2100 3263              * Input:  CDA number in Y ($FF=Quit, 0=Control Panel, 1..NumDAs=other)
2101 3263              * Output: A (uppercase)
2102 3263              *
2103 3263 98           GetCDALetterY tya   
2104 3264 D0 04                 bne   @NotLetterCP
2105 3266 A9 43 00              lda   #$43                     ;C for Control Panel
2106 3269 60                    rts   
2107 326A C9 FF 00     @NotLetterCP cmp   #$00ff
2108 326D D0 04                 bne   @NotLetterQuit
2109 326F A9 51 00              lda   #$51                     ;Q for Quit
2110 3272 60                    rts   
2111 3273 5A           @NotLetterQuit phy   
2112 3274 20 9D 37              jsr   DerefCDAy
2113 3277 A0 01 00              ldy   #1
2114 327A B7 40                 lda   [temp2],y                ;CDA names sometimes have bit 7 on!
2115 327C 7A                    ply   
2116 327D 29 7F 00     upcase   and   #$007f
2117 3280 C9 61 00              cmp   #$61                     ;'a', high bit off
2118 3283 90 08                 bcc   @1
2119 3285 C9 7B 00              cmp   #$7a+1                   ;'z'+1, high bit off
2120 3288 B0 03                 bcs   @1
2121 328A 29 5F 00              and   #$5f
2122 328D 60           @1       rts   
2123 328E
2124 328E              *
2125 328E              * NextCDAy -- advance Y to the next CDA
2126 328E              *
2127 328E              * (If Y = NumDAs, advance to $FF; else advance by 1, and keep
2128 328E              * bottom 8 bits.  Advances from Quit($FF) to Control Panel(0),
2129 328E              * from Control Panel(0) to 1.)
2130 328E              *
2131 328E CC 7C 1D     NextCDAy cpy   |NumDAs
2132 3291 D0 03                 bne   @1
2133 3293 A0 FE 00              ldy   #$fe
2134 3296 C8           @1       iny   
2135 3297 98                    tya   
2136 3298 29 FF 00              and   #$00ff
2137 329B A8                    tay   
2138 329C 60                    rts   
2139 329D
2140 329D                       EndP 
2141 329D
2142 329D              **********************************************************************
2143 329D              *
2144 329D              * DerefCDAy -- split into a subroutine 12-Feb-91 DAL
2145 329D              *
2146 329D              * Input: Y = 1..NumDAs
2147 329D              * Output: temp2 = pointer to CDA header (pString, entry, shutdown)
2148 329D              *
2149 329D              **********************************************************************
2150 329D              DerefCDAy proc export 
2151 329D AD A8 1D              lda   |cdatabptr               ; copy the table pointer into
2152 32A0 85 40                 sta   temp2                    ; the direct page
2153 32A2 AD AA 1D              lda   |cdatabptr+2
2154 32A5 85 42                 sta   temp2+2
2155 32A7 98                    tya   
2156 32A8 3A                    dec   a
2157 32A9 0A                    asl   a                        ; adjust y
2158 32AA 0A                    asl   a
2159 32AB A8                    tay   
2160 32AC B7 40                 lda   [temp2],y                ; get a handle to the da
2161 32AE 85 3C                 sta   temp1
2162 32B0 C8                    iny   
2163 32B1 C8                    iny   
2164 32B2 B7 40                 lda   [temp2],y
2165 32B4 85 3E                 sta   temp1+2
2166 32B6 20 3C 36              jsr   deref                    ; deref the handle
2167 32B9 60                    rts   
2168 32BA                       EndP 
2169 32BA
2170 32BA                       END   
